/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import ai.timefold.solver.core.impl.solver.termination.ChildThreadSupportingTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import ai.timefold.solver.core.impl.util.Pair;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination<Solution_>
extends AbstractUniversalTermination<Solution_>
implements ChildThreadSupportingTermination<Solution_, SolverScope<Solution_>> {
    private final long unimprovedTimeMillisSpentLimit;
    private final Score<?> unimprovedScoreDifferenceThreshold;
    private final Clock clock;
    private @Nullable Queue<Pair<Long, Score<?>>> bestScoreImprovementHistoryQueue;
    private long solverSafeTimeMillis = -1L;
    private long phaseSafeTimeMillis = -1L;
    private boolean currentPhaseSendsBestSolutionEvents = false;

    public UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(long unimprovedTimeMillisSpentLimit, Score<?> unimprovedScoreDifferenceThreshold) {
        this(unimprovedTimeMillisSpentLimit, unimprovedScoreDifferenceThreshold, Clock.systemUTC());
    }

    UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(long unimprovedTimeMillisSpentLimit, Score<?> unimprovedScoreDifferenceThreshold, Clock clock) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        if (unimprovedTimeMillisSpentLimit < 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (%d) cannot be negative.".formatted(unimprovedTimeMillisSpentLimit));
        }
        this.unimprovedScoreDifferenceThreshold = unimprovedScoreDifferenceThreshold;
        this.clock = clock;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.resetState();
    }

    void resetState() {
        this.bestScoreImprovementHistoryQueue = new ArrayDeque();
        this.solverSafeTimeMillis = this.clock.millis() + this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.bestScoreImprovementHistoryQueue = null;
        this.solverSafeTimeMillis = -1L;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.phaseSafeTimeMillis = phaseScope.getStartingSystemTimeMillis() + this.unimprovedTimeMillisSpentLimit;
        this.currentPhaseSendsBestSolutionEvents = phaseScope.isPhaseSendingBestSolutionEvents();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.phaseSafeTimeMillis = -1L;
        if (!this.currentPhaseSendsBestSolutionEvents) {
            this.resetState();
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        if (stepScope.getBestScoreImproved()) {
            SolverScope<Solution_> solverScope = stepScope.getPhaseScope().getSolverScope();
            long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
            Score bestScore = solverScope.getBestScore();
            Iterator it = this.bestScoreImprovementHistoryQueue.iterator();
            while (it.hasNext()) {
                long safeTimeMillis;
                boolean scoreImprovedOverThreshold;
                Pair bestScoreImprovement = (Pair)it.next();
                Score scoreDifference = bestScore.subtract((Score)bestScoreImprovement.value());
                boolean timeLimitNotYetReached = (Long)bestScoreImprovement.key() + this.unimprovedTimeMillisSpentLimit >= bestSolutionTimeMillis;
                boolean bl = scoreImprovedOverThreshold = scoreDifference.compareTo(this.unimprovedScoreDifferenceThreshold) >= 0;
                if (!scoreImprovedOverThreshold || !timeLimitNotYetReached) break;
                it.remove();
                this.solverSafeTimeMillis = safeTimeMillis = bestSolutionTimeMillis + this.unimprovedTimeMillisSpentLimit;
                this.phaseSafeTimeMillis = safeTimeMillis;
            }
            this.bestScoreImprovementHistoryQueue.add(new Pair<Long, Score>(bestSolutionTimeMillis, bestScore));
        }
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        return this.isTerminated(this.solverSafeTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isTerminated(this.phaseSafeTimeMillis);
    }

    private boolean isTerminated(long safeTimeMillis) {
        if (!this.currentPhaseSendsBestSolutionEvents) {
            return false;
        }
        long now = this.clock.millis();
        return now > safeTimeMillis;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return this.calculateTimeGradient(this.solverSafeTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateTimeGradient(this.phaseSafeTimeMillis);
    }

    private double calculateTimeGradient(long safeTimeMillis) {
        if (!this.currentPhaseSendsBestSolutionEvents) {
            return 0.0;
        }
        long now = this.clock.millis();
        long unimprovedTimeMillisSpent = now - (safeTimeMillis - this.unimprovedTimeMillisSpentLimit);
        double timeGradient = (double)unimprovedTimeMillisSpent / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination<Solution_>(this.unimprovedTimeMillisSpentLimit, this.unimprovedScoreDifferenceThreshold);
    }

    @Override
    public boolean isApplicableTo(Class<? extends AbstractPhaseScope> phaseScopeClass) {
        return phaseScopeClass != ConstructionHeuristicPhaseScope.class && phaseScopeClass != CustomPhaseScope.class;
    }

    public String toString() {
        return "UnimprovedTimeMillisSpent(" + this.unimprovedTimeMillisSpentLimit + ")";
    }
}

