/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class DiminishedReturnsScoreRingBuffer<Score_ extends Score<Score_>> {
    private static final int DEFAULT_CAPACITY = 4096;
    int readIndex;
    int writeIndex;
    private long[] nanoTimeRingBuffer;
    private Score_[] scoreRingBuffer;

    DiminishedReturnsScoreRingBuffer() {
        this(4096);
    }

    DiminishedReturnsScoreRingBuffer(int capacity) {
        this(0, 0, new long[capacity], new Score[capacity]);
    }

    DiminishedReturnsScoreRingBuffer(int readIndex, int writeIndex, long[] nanoTimeRingBuffer, @Nullable Score_[] scoreRingBuffer) {
        this.nanoTimeRingBuffer = nanoTimeRingBuffer;
        this.scoreRingBuffer = scoreRingBuffer;
        this.readIndex = readIndex;
        this.writeIndex = writeIndex;
    }

    @NonNull RingBufferState getState() {
        return new RingBufferState(this.readIndex, this.writeIndex, this.nanoTimeRingBuffer, (Score<?>[])this.scoreRingBuffer);
    }

    void resize() {
        int newCapacity = this.nanoTimeRingBuffer.length * 2;
        long[] newNanoTimeRingBuffer = new long[newCapacity];
        Score[] newScoreRingBuffer = new Score[newCapacity];
        if (this.readIndex < this.writeIndex) {
            int newLength = this.writeIndex - this.readIndex;
            System.arraycopy(this.nanoTimeRingBuffer, this.readIndex, newNanoTimeRingBuffer, 0, newLength);
            System.arraycopy(this.scoreRingBuffer, this.readIndex, newScoreRingBuffer, 0, newLength);
            this.readIndex = 0;
            this.writeIndex = newLength;
        } else {
            int firstLength = this.nanoTimeRingBuffer.length - this.readIndex;
            int secondLength = this.writeIndex;
            int totalLength = firstLength + secondLength;
            System.arraycopy(this.nanoTimeRingBuffer, this.readIndex, newNanoTimeRingBuffer, 0, firstLength);
            System.arraycopy(this.scoreRingBuffer, this.readIndex, newScoreRingBuffer, 0, firstLength);
            System.arraycopy(this.nanoTimeRingBuffer, 0, newNanoTimeRingBuffer, firstLength, secondLength);
            System.arraycopy(this.scoreRingBuffer, 0, newScoreRingBuffer, firstLength, secondLength);
            this.readIndex = 0;
            this.writeIndex = totalLength;
        }
        this.nanoTimeRingBuffer = newNanoTimeRingBuffer;
        this.scoreRingBuffer = newScoreRingBuffer;
    }

    public void clear() {
        this.readIndex = 0;
        this.writeIndex = 0;
        Arrays.fill(this.nanoTimeRingBuffer, 0L);
        Arrays.fill(this.scoreRingBuffer, null);
    }

    public @NonNull Score_ peekFirst() {
        Score_ out = this.scoreRingBuffer[this.readIndex];
        if (out == null) {
            throw new IllegalStateException("Impossible state: buffer is empty");
        }
        return out;
    }

    public void put(long nanoTime, @NonNull Score_ score) {
        if (this.nanoTimeRingBuffer[this.writeIndex] != 0L) {
            this.resize();
        }
        this.nanoTimeRingBuffer[this.writeIndex] = nanoTime;
        this.scoreRingBuffer[this.writeIndex] = score;
        this.writeIndex = (this.writeIndex + 1) % this.nanoTimeRingBuffer.length;
    }

    private @NonNull Score_ clearCountAndPeekNext(int count) {
        if (this.readIndex + count < this.nanoTimeRingBuffer.length) {
            Arrays.fill(this.nanoTimeRingBuffer, this.readIndex, this.readIndex + count, 0L);
            Arrays.fill(this.scoreRingBuffer, this.readIndex, this.readIndex + count, null);
            this.readIndex += count;
        } else {
            int remaining = count - (this.nanoTimeRingBuffer.length - this.readIndex);
            Arrays.fill(this.nanoTimeRingBuffer, this.readIndex, this.nanoTimeRingBuffer.length, 0L);
            Arrays.fill(this.scoreRingBuffer, this.readIndex, this.nanoTimeRingBuffer.length, null);
            Arrays.fill(this.nanoTimeRingBuffer, 0, remaining, 0L);
            Arrays.fill(this.scoreRingBuffer, 0, remaining, null);
            this.readIndex = remaining;
        }
        return this.scoreRingBuffer[this.readIndex];
    }

    public @NonNull Score_ pollLatestScoreBeforeTimeAndClearPrior(long nanoTime) {
        if (this.readIndex == this.writeIndex && this.nanoTimeRingBuffer[this.writeIndex] == 0L) {
            throw new IllegalStateException("Impossible state: buffer is empty");
        }
        int end = this.readIndex < this.writeIndex ? this.writeIndex : this.nanoTimeRingBuffer.length;
        for (int i = this.readIndex; i < end; ++i) {
            if (this.nanoTimeRingBuffer[i] == nanoTime) {
                return this.clearCountAndPeekNext(i - this.readIndex);
            }
            if (this.nanoTimeRingBuffer[i] <= nanoTime) continue;
            return this.clearCountAndPeekNext(i - this.readIndex - 1);
        }
        int countRead = end - this.readIndex;
        if (this.writeIndex < this.readIndex && this.writeIndex != 0) {
            if (this.nanoTimeRingBuffer[0] == nanoTime) {
                return this.clearCountAndPeekNext(countRead);
            }
            if (this.nanoTimeRingBuffer[0] > nanoTime) {
                return this.clearCountAndPeekNext(countRead - 1);
            }
            for (int i = 1; i < this.writeIndex; ++i) {
                if (this.nanoTimeRingBuffer[i] == nanoTime) {
                    return this.clearCountAndPeekNext(countRead + i);
                }
                if (this.nanoTimeRingBuffer[i] <= nanoTime) continue;
                return this.clearCountAndPeekNext(countRead + i - 1);
            }
            return this.clearCountAndPeekNext(countRead + this.writeIndex - 1);
        }
        return this.clearCountAndPeekNext(countRead - 1);
    }

    record RingBufferState(int readIndex, int writeIndex, long[] nanoTimeRingBuffer, @Nullable Score<?>[] scoreRingBuffer) {
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RingBufferState)) {
                return false;
            }
            RingBufferState that = (RingBufferState)o;
            return this.readIndex == that.readIndex && this.writeIndex == that.writeIndex && Objects.deepEquals(this.nanoTimeRingBuffer, that.nanoTimeRingBuffer) && Objects.deepEquals(this.scoreRingBuffer, that.scoreRingBuffer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.readIndex, this.writeIndex, Arrays.hashCode(this.nanoTimeRingBuffer), Arrays.hashCode(this.scoreRingBuffer));
        }

        @Override
        public String toString() {
            return "RingBufferState{readIndex=" + this.readIndex + ", writeIndex=" + this.writeIndex + ", nanoTimeRingBuffer=" + Arrays.toString(this.nanoTimeRingBuffer) + ", scoreRingBuffer=" + Arrays.toString(this.scoreRingBuffer) + "}";
        }
    }
}

