/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.BendableScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.util.Arrays;
import java.util.Map;

final class BendableScoreInliner
extends AbstractScoreInliner<BendableScore> {
    final int[] hardScores;
    final int[] softScores;

    BendableScoreInliner(Map<Constraint, BendableScore> constraintWeightMap, ConstraintMatchPolicy constraintMatchPolicy, int hardLevelsSize, int softLevelsSize) {
        super(constraintWeightMap, constraintMatchPolicy);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter<BendableScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        Integer singleLevel = null;
        BendableScore constraintWeight = (BendableScore)this.constraintWeightMap.get(constraint);
        for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
            if ((long)constraintWeight.hardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.hardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.hardLevelsSize();
            BendableScoreContext context = new BendableScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.hardOrSoftScore(singleLevel));
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, BendableScoreContext::changeHardScoreBy);
            }
            return WeightedScoreImpacter.of(context, BendableScoreContext::changeSoftScoreBy);
        }
        BendableScoreContext context = new BendableScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length);
        return WeightedScoreImpacter.of(context, BendableScoreContext::changeScoreBy);
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableScore.class.getSimpleName() + " inliner";
    }
}

