/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.impl.util.Triple;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

final class ComposeThreeBiCollector<A, B, ResultHolder1_, ResultHolder2_, ResultHolder3_, Result1_, Result2_, Result3_, Result_>
implements BiConstraintCollector<A, B, Triple<ResultHolder1_, ResultHolder2_, ResultHolder3_>, Result_> {
    private final BiConstraintCollector<A, B, ResultHolder1_, Result1_> first;
    private final BiConstraintCollector<A, B, ResultHolder2_, Result2_> second;
    private final BiConstraintCollector<A, B, ResultHolder3_, Result3_> third;
    private final TriFunction<Result1_, Result2_, Result3_, Result_> composeFunction;
    private final Supplier<ResultHolder1_> firstSupplier;
    private final Supplier<ResultHolder2_> secondSupplier;
    private final Supplier<ResultHolder3_> thirdSupplier;
    private final TriFunction<ResultHolder1_, A, B, Runnable> firstAccumulator;
    private final TriFunction<ResultHolder2_, A, B, Runnable> secondAccumulator;
    private final TriFunction<ResultHolder3_, A, B, Runnable> thirdAccumulator;
    private final Function<ResultHolder1_, Result1_> firstFinisher;
    private final Function<ResultHolder2_, Result2_> secondFinisher;
    private final Function<ResultHolder3_, Result3_> thirdFinisher;

    ComposeThreeBiCollector(BiConstraintCollector<A, B, ResultHolder1_, Result1_> first, BiConstraintCollector<A, B, ResultHolder2_, Result2_> second, BiConstraintCollector<A, B, ResultHolder3_, Result3_> third, TriFunction<Result1_, Result2_, Result3_, Result_> composeFunction) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.composeFunction = composeFunction;
        this.firstSupplier = first.supplier();
        this.secondSupplier = second.supplier();
        this.thirdSupplier = third.supplier();
        this.firstAccumulator = first.accumulator();
        this.secondAccumulator = second.accumulator();
        this.thirdAccumulator = third.accumulator();
        this.firstFinisher = first.finisher();
        this.secondFinisher = second.finisher();
        this.thirdFinisher = third.finisher();
    }

    @Override
    public @NonNull Supplier<Triple<ResultHolder1_, ResultHolder2_, ResultHolder3_>> supplier() {
        return () -> {
            ResultHolder1_ a = this.firstSupplier.get();
            ResultHolder2_ b = this.secondSupplier.get();
            return new Triple<ResultHolder1_, ResultHolder2_, ResultHolder3_>(a, b, this.thirdSupplier.get());
        };
    }

    @Override
    public @NonNull TriFunction<Triple<ResultHolder1_, ResultHolder2_, ResultHolder3_>, A, B, Runnable> accumulator() {
        return (resultHolder, a, b) -> ComposeThreeBiCollector.composeUndo(this.firstAccumulator.apply(resultHolder.a(), a, b), this.secondAccumulator.apply(resultHolder.b(), a, b), this.thirdAccumulator.apply(resultHolder.c(), a, b));
    }

    private static Runnable composeUndo(Runnable first, Runnable second, Runnable third) {
        return () -> {
            first.run();
            second.run();
            third.run();
        };
    }

    @Override
    public @NonNull Function<Triple<ResultHolder1_, ResultHolder2_, ResultHolder3_>, Result_> finisher() {
        return resultHolder -> this.composeFunction.apply(this.firstFinisher.apply(resultHolder.a()), this.secondFinisher.apply(resultHolder.b()), this.thirdFinisher.apply(resultHolder.c()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ComposeThreeBiCollector that = (ComposeThreeBiCollector)object;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.third, that.third) && Objects.equals(this.composeFunction, that.composeFunction);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third, this.composeFunction);
    }
}

