/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.NonNull;

public final class DefaultScoreExplanation<Solution_, Score_ extends Score<Score_>>
implements ScoreExplanation<Solution_, Score_> {
    private static final int DEFAULT_SCORE_EXPLANATION_INDICTMENT_LIMIT = 5;
    private static final int DEFAULT_SCORE_EXPLANATION_CONSTRAINT_MATCH_LIMIT = 2;
    private final Solution_ solution;
    private final Score_ score;
    private final Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    private final List<ConstraintJustification> constraintJustificationList;
    private final Map<Object, Indictment<Score_>> indictmentMap;
    private final AtomicReference<String> summary = new AtomicReference();

    public static <Score_ extends Score<Score_>> String explainScore(Score_ workingScore, Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection, Collection<Indictment<Score_>> indictmentCollection) {
        return DefaultScoreExplanation.explainScore(workingScore, constraintMatchTotalCollection, indictmentCollection, 5, 2);
    }

    public static <Score_ extends Score<Score_>> String explainScore(Score_ workingScore, Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection, Collection<Indictment<Score_>> indictmentCollection, int indictmentLimit, int constraintMatchLimit) {
        StringBuilder scoreExplanation = new StringBuilder((constraintMatchTotalCollection.size() + 4 + 2 * indictmentLimit) * 80);
        scoreExplanation.append("Explanation of score (%s):\n    Constraint matches:\n".formatted(workingScore));
        Comparator<ConstraintMatchTotal> constraintMatchTotalComparator = Comparator.comparing(ConstraintMatchTotal::getScore);
        Comparator<ConstraintMatch> constraintMatchComparator = Comparator.comparing(ConstraintMatch::getScore);
        constraintMatchTotalCollection.stream().sorted(constraintMatchTotalComparator).forEach(constraintMatchTotal -> {
            Set constraintMatchSet = constraintMatchTotal.getConstraintMatchSet();
            scoreExplanation.append("        %s: constraint (%s) has %s matches:\n".formatted(constraintMatchTotal.getScore().toShortString(), constraintMatchTotal.getConstraintRef().constraintName(), constraintMatchSet.size()));
            constraintMatchSet.stream().sorted(constraintMatchComparator).limit(constraintMatchLimit).forEach(constraintMatch -> {
                if (constraintMatch.getJustification() == null) {
                    scoreExplanation.append("           %s: unjustified\n".formatted(constraintMatch.getScore().toShortString()));
                } else {
                    scoreExplanation.append("            %s: justified with (%s)\n".formatted(constraintMatch.getScore().toShortString(), constraintMatch.getJustification()));
                }
            });
            if (constraintMatchSet.size() > constraintMatchLimit) {
                scoreExplanation.append("            ...\n");
            }
        });
        int indictmentCount = indictmentCollection.size();
        if (indictmentLimit < indictmentCount) {
            scoreExplanation.append("    Indictments (top %s of %s):\n".formatted(indictmentLimit, indictmentCount));
        } else {
            scoreExplanation.append("    Indictments:\n");
        }
        Comparator<Indictment> indictmentComparator = Comparator.comparing(Indictment::getScore);
        Comparator<ConstraintMatch> constraintMatchScoreComparator = Comparator.comparing(ConstraintMatch::getScore);
        indictmentCollection.stream().sorted(indictmentComparator).limit(indictmentLimit).forEach(indictment -> {
            Set constraintMatchSet = indictment.getConstraintMatchSet();
            scoreExplanation.append("        %s: indicted with (%s) has %s matches:\n".formatted(indictment.getScore().toShortString(), indictment.getIndictedObject(), constraintMatchSet.size()));
            constraintMatchSet.stream().sorted(constraintMatchScoreComparator).limit(constraintMatchLimit).forEach(constraintMatch -> scoreExplanation.append("            %s: constraint (%s)\n".formatted(constraintMatch.getScore().toShortString(), constraintMatch.getConstraintRef().constraintName())));
            if (constraintMatchSet.size() > constraintMatchLimit) {
                scoreExplanation.append("            ...\n");
            }
        });
        if (indictmentCount > indictmentLimit) {
            scoreExplanation.append("        ...\n");
        }
        return scoreExplanation.toString();
    }

    public DefaultScoreExplanation(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        this(scoreDirector.getWorkingSolution(), scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
    }

    public DefaultScoreExplanation(Solution_ solution, Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.solution = solution;
        this.score = score;
        this.constraintMatchTotalMap = constraintMatchTotalMap;
        ArrayList workingConstraintJustificationList = new ArrayList();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : constraintMatchTotalMap.values()) {
            for (ConstraintMatch<Score_> constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                Object justification = constraintMatch.getJustification();
                if (justification == null) continue;
                workingConstraintJustificationList.add(justification);
            }
        }
        this.constraintJustificationList = workingConstraintJustificationList.isEmpty() ? Collections.emptyList() : workingConstraintJustificationList;
        this.indictmentMap = indictmentMap;
    }

    @Override
    public @NonNull Solution_ getSolution() {
        return this.solution;
    }

    @Override
    public @NonNull Score_ getScore() {
        return this.score;
    }

    @Override
    public @NonNull Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.constraintMatchTotalMap;
    }

    @Override
    public @NonNull List<ConstraintJustification> getJustificationList() {
        return this.constraintJustificationList;
    }

    @Override
    public @NonNull Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.indictmentMap;
    }

    @Override
    public @NonNull String getSummary() {
        return this.summary.updateAndGet(currentSummary -> Objects.requireNonNullElseGet(currentSummary, () -> DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalMap.values(), this.indictmentMap.values())));
    }

    public String toString() {
        return this.getSummary();
    }
}

