/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.custom;

import ai.timefold.solver.core.api.solver.phase.PhaseCommand;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.phase.AbstractPossiblyInitializingPhase;
import ai.timefold.solver.core.impl.phase.PossiblyInitializingPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhase;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomPhaseScope;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomStepScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultCustomPhase<Solution_>
extends AbstractPossiblyInitializingPhase<Solution_>
implements CustomPhase<Solution_> {
    private final List<PhaseCommand<Solution_>> customPhaseCommandList;
    private PossiblyInitializingPhase.TerminationStatus terminationStatus = PossiblyInitializingPhase.TerminationStatus.NOT_TERMINATED;

    private DefaultCustomPhase(DefaultCustomPhaseBuilder<Solution_> builder) {
        super(builder);
        this.customPhaseCommandList = builder.customPhaseCommandList;
    }

    @Override
    public PossiblyInitializingPhase.TerminationStatus getTerminationStatus() {
        return this.terminationStatus;
    }

    @Override
    public String getPhaseTypeString() {
        return "Custom";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        CustomPhaseScope<Solution_> phaseScope = new CustomPhaseScope<Solution_>(solverScope, this.phaseIndex);
        this.phaseStarted(phaseScope);
        PossiblyInitializingPhase.TerminationStatus earlyTerminationStatus = null;
        Iterator<PhaseCommand<Solution_>> iterator = this.customPhaseCommandList.iterator();
        while (iterator.hasNext()) {
            PhaseCommand<Solution_> customPhaseCommand = iterator.next();
            solverScope.checkYielding();
            if (this.phaseTermination.isPhaseTerminated(phaseScope)) {
                earlyTerminationStatus = PossiblyInitializingPhase.TerminationStatus.early(phaseScope.getNextStepIndex());
                break;
            }
            CustomStepScope<Solution_> stepScope = new CustomStepScope<Solution_>(phaseScope);
            this.stepStarted(stepScope);
            this.doStep(stepScope, customPhaseCommand);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.terminationStatus = DefaultCustomPhase.translateEarlyTermination(phaseScope, earlyTerminationStatus, iterator.hasNext());
        this.phaseEnded(phaseScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.terminationStatus = PossiblyInitializingPhase.TerminationStatus.NOT_TERMINATED;
    }

    private void doStep(CustomStepScope<Solution_> stepScope, PhaseCommand<Solution_> customPhaseCommand) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        customPhaseCommand.changeWorkingSolution(scoreDirector, () -> this.phaseTermination.isPhaseTerminated(stepScope.getPhaseScope()));
        this.calculateWorkingStepScore(stepScope, customPhaseCommand);
        AbstractSolver solver = stepScope.getPhaseScope().getSolverScope().getSolver();
        solver.getBestSolutionRecaller().processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void stepEnded(CustomStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    Custom step ({}), time spent ({}), score ({}), {} best score ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() ? "new" : "   ", phaseScope.getBestScore()});
        }
    }

    @Override
    public void phaseEnded(CustomPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.ensureCorrectTermination(phaseScope, this.logger);
        phaseScope.endingNow();
        this.logger.info("{}Custom phase ({}) ended: time spent ({}), best score ({}), move evaluation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseMoveEvaluationSpeed(), phaseScope.getNextStepIndex()});
    }

    public static final class DefaultCustomPhaseBuilder<Solution_>
    extends AbstractPossiblyInitializingPhase.AbstractPossiblyInitializingPhaseBuilder<Solution_> {
        private final List<PhaseCommand<Solution_>> customPhaseCommandList;

        public DefaultCustomPhaseBuilder(int phaseIndex, boolean lastInitializingPhase, String logIndentation, PhaseTermination<Solution_> phaseTermination, List<PhaseCommand<Solution_>> customPhaseCommandList) {
            super(phaseIndex, lastInitializingPhase, logIndentation, phaseTermination);
            this.customPhaseCommandList = List.copyOf(customPhaseCommandList);
        }

        @Override
        public DefaultCustomPhaseBuilder<Solution_> enableAssertions(EnvironmentMode environmentMode) {
            super.enableAssertions(environmentMode);
            return this;
        }

        @Override
        public DefaultCustomPhase<Solution_> build() {
            return new DefaultCustomPhase(this);
        }
    }
}

