/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.lateacceptance;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import java.util.Arrays;

public class LateAcceptanceAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected int lateAcceptanceSize = -1;
    protected boolean hillClimbingEnabled = true;
    protected Score<?>[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    public void setHillClimbingEnabled(boolean hillClimbingEnabled) {
        this.hillClimbingEnabled = hillClimbingEnabled;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAcceptanceSize];
        Object initialScore = phaseScope.getBestScore();
        Arrays.fill(this.previousScores, initialScore);
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (%d) cannot be negative or zero.".formatted(this.lateAcceptanceSize));
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        Score<?> lateScore;
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lateScore = this.previousScores[this.lateScoreIndex]) >= 0) {
            return true;
        }
        if (this.hillClimbingEnabled) {
            Score<?> lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
            return moveScore.compareTo(lastStepScore) >= 0;
        }
        return false;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.previousScores[this.lateScoreIndex] = stepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }
}

