/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.lateacceptance;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import java.util.Arrays;

public class DiversifiedLateAcceptanceAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected Score<?> lateWorse;
    protected int lateWorseOccurrences = -1;
    protected int lateAcceptanceSize = -1;
    protected Score<?>[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAcceptanceSize];
        Object initialScore = phaseScope.getBestScore();
        Arrays.fill(this.previousScores, initialScore);
        this.lateScoreIndex = 0;
        this.lateWorseOccurrences = this.lateAcceptanceSize;
        this.lateWorse = initialScore;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (%d) cannot be negative or zero.".formatted(this.lateAcceptanceSize));
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        boolean currentScoreBetter;
        Score<?> lateScore;
        int currentScoreCmp;
        boolean accept;
        Score current;
        Score moveScore = moveScope.getScore();
        Score previous = current = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        boolean bl = accept = moveScore.compareTo(current) == 0 || moveScore.compareTo(this.lateWorse) > 0;
        if (accept) {
            current = moveScore;
        }
        boolean currentScoreWorse = (currentScoreCmp = current.compareTo(lateScore = this.previousScores[this.lateScoreIndex])) < 0;
        boolean bl2 = currentScoreBetter = currentScoreCmp > 0 && current.compareTo(previous) > 0;
        if (currentScoreWorse || currentScoreBetter) {
            this.updateLateScore(current);
        }
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
        return accept;
    }

    private void updateLateScore(Score newScore) {
        boolean lateScoreEqual;
        int newScoreWorseCmp = newScore.compareTo(this.lateWorse);
        Score<?> lateScore = this.previousScores[this.lateScoreIndex];
        boolean bl = lateScoreEqual = lateScore.compareTo(this.lateWorse) == 0;
        if (newScoreWorseCmp < 0) {
            this.lateWorse = newScore;
            this.lateWorseOccurrences = 1;
        } else if (lateScoreEqual && newScoreWorseCmp != 0) {
            --this.lateWorseOccurrences;
        } else if (!lateScoreEqual && newScoreWorseCmp == 0) {
            ++this.lateWorseOccurrences;
        }
        this.previousScores[this.lateScoreIndex] = newScore;
        if (this.lateWorseOccurrences == 0) {
            this.lateWorse = this.previousScores[0];
            this.lateWorseOccurrences = 1;
            for (int i = 1; i < this.lateAcceptanceSize; ++i) {
                Score<?> previousScore = this.previousScores[i];
                int scoreCmp = previousScore.compareTo(this.lateWorse);
                if (scoreCmp < 0) {
                    this.lateWorse = this.previousScores[i];
                    this.lateWorseOccurrences = 1;
                    continue;
                }
                if (scoreCmp != 0) continue;
                ++this.lateWorseOccurrences;
            }
        }
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
        this.lateWorse = null;
        this.lateWorseOccurrences = -1;
    }
}

