/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.RuinRecreateMoveSelectorConfig;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.CountSupplier;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateMoveSelector;
import java.util.List;

public final class RuinRecreateMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, RuinRecreateMoveSelectorConfig> {
    private final RuinRecreateMoveSelectorConfig ruinRecreateMoveSelectorConfig;

    public RuinRecreateMoveSelectorFactory(RuinRecreateMoveSelectorConfig ruinRecreateMoveSelectorConfig) {
        super(ruinRecreateMoveSelectorConfig);
        this.ruinRecreateMoveSelectorConfig = ruinRecreateMoveSelectorConfig;
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        CountSupplier minimumSelectedSupplier = this.ruinRecreateMoveSelectorConfig::determineMinimumRuinedCount;
        CountSupplier maximumSelectedSupplier = this.ruinRecreateMoveSelectorConfig::determineMaximumRuinedCount;
        EntitySelector entitySelector = EntitySelectorFactory.create(new EntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(true));
        List genuineVariableDescriptorList = entitySelector.getEntityDescriptor().getGenuineVariableDescriptorList();
        if (genuineVariableDescriptorList.size() != 1) {
            throw new UnsupportedOperationException("Ruin and Recreate move selector currently only supports 1 planning variable.");
        }
        GenuineVariableDescriptor variableDescriptor = genuineVariableDescriptorList.get(0);
        RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder = RuinRecreateConstructionHeuristicPhaseBuilder.create(configPolicy);
        return new RuinRecreateMoveSelector(entitySelector, variableDescriptor, constructionHeuristicPhaseBuilder, minimumSelectedSupplier, maximumSelectedSupplier);
    }
}

