/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.impl.domain.variable.ExternalizedIndexVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.ExternalizedListInverseVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.ExternalizedNextPrevElementVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.List;
import java.util.Map;

final class ListVariableState<Solution_> {
    private final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private ExternalizedIndexVariableProcessor<Solution_> externalizedIndexProcessor = null;
    private ExternalizedListInverseVariableProcessor<Solution_> externalizedInverseProcessor = null;
    private ExternalizedNextPrevElementVariableProcessor<Solution_> externalizedPreviousElementProcessor = null;
    private ExternalizedNextPrevElementVariableProcessor<Solution_> externalizedNextElementProcessor = null;
    private boolean requiresLocationMap = true;
    private InnerScoreDirector<Solution_, ?> scoreDirector;
    private int unassignedCount = 0;
    private Map<Object, MutableLocationInList> elementLocationMap;

    public ListVariableState(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    public void linkShadowVariable(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedIndexProcessor = new ExternalizedIndexVariableProcessor<Solution_>(shadowVariableDescriptor);
    }

    public void linkShadowVariable(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedInverseProcessor = new ExternalizedListInverseVariableProcessor<Solution_>(shadowVariableDescriptor, this.sourceVariableDescriptor);
    }

    public void linkShadowVariable(PreviousElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedPreviousElementProcessor = ExternalizedNextPrevElementVariableProcessor.ofPrevious(shadowVariableDescriptor);
    }

    public void linkShadowVariable(NextElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedNextElementProcessor = ExternalizedNextPrevElementVariableProcessor.ofNext(shadowVariableDescriptor);
    }

    public void initialize(InnerScoreDirector<Solution_, ?> scoreDirector, int initialUnassignedCount) {
        this.scoreDirector = scoreDirector;
        this.unassignedCount = initialUnassignedCount;
        boolean bl = this.requiresLocationMap = this.externalizedIndexProcessor == null || this.externalizedInverseProcessor == null || this.externalizedPreviousElementProcessor == null || this.externalizedNextElementProcessor == null;
        if (this.requiresLocationMap) {
            if (this.elementLocationMap == null) {
                this.elementLocationMap = CollectionUtils.newIdentityHashMap(this.unassignedCount);
            } else {
                this.elementLocationMap.clear();
            }
        } else {
            this.elementLocationMap = null;
        }
    }

    public void addElement(Object entity, List<Object> elements, Object element, int index) {
        MutableLocationInList oldLocation;
        if (this.requiresLocationMap && (oldLocation = this.elementLocationMap.put(element, new MutableLocationInList(entity, index))) != null) {
            throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) already exists (%s).".formatted(this.sourceVariableDescriptor, element, index, oldLocation));
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.addElement(this.scoreDirector, element, index);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.addElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        --this.unassignedCount;
    }

    public void removeElement(Object entity, Object element, int index) {
        if (this.requiresLocationMap) {
            MutableLocationInList oldElementLocation = this.elementLocationMap.remove(element);
            if (oldElementLocation == null) {
                throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) was already unassigned (%s).".formatted(this.sourceVariableDescriptor, element, index, oldElementLocation));
            }
            int oldIndex = oldElementLocation.getIndex();
            if (oldIndex != index) {
                throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) had an old index (%d) which is not the current index (%d).".formatted(this.sourceVariableDescriptor, element, index, oldIndex, index));
            }
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.removeElement(this.scoreDirector, element);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.removeElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.unsetElement(this.scoreDirector, element);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.unsetElement(this.scoreDirector, element);
        }
        ++this.unassignedCount;
    }

    public void unassignElement(Object element) {
        MutableLocationInList oldLocation;
        if (this.requiresLocationMap && (oldLocation = this.elementLocationMap.remove(element)) == null) {
            throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) did not exist before unassigning.".formatted(this.sourceVariableDescriptor, element));
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.unassignElement(this.scoreDirector, element);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.unassignElement(this.scoreDirector, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.unsetElement(this.scoreDirector, element);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.unsetElement(this.scoreDirector, element);
        }
        ++this.unassignedCount;
    }

    public boolean changeElement(Object entity, List<Object> elements, int index) {
        Object element = elements.get(index);
        ChangeType difference = this.processElementLocation(entity, element, index);
        if (difference.indexChanged && this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.changeElement(this.scoreDirector, element, index);
        }
        if (difference.entityChanged && this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.changeElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        return difference.anythingChanged;
    }

    private ChangeType processElementLocation(Object entity, Object element, int index) {
        if (this.requiresLocationMap) {
            MutableLocationInList oldLocation = this.elementLocationMap.get(element);
            if (oldLocation == null) {
                this.elementLocationMap.put(element, new MutableLocationInList(entity, index));
                --this.unassignedCount;
                return ChangeType.BOTH;
            }
            ChangeType changeType = ListVariableState.compareLocations(entity, oldLocation.getEntity(), index, oldLocation.getIndex());
            if (changeType.anythingChanged) {
                if (changeType.entityChanged) {
                    oldLocation.setEntity(entity);
                }
                if (changeType.indexChanged) {
                    oldLocation.setIndex(index);
                }
            }
            return changeType;
        }
        Object oldEntity = this.getInverseSingleton(element);
        if (oldEntity == null) {
            --this.unassignedCount;
            return ChangeType.BOTH;
        }
        Integer oldIndex = this.getIndex(element);
        if (oldIndex == null) {
            return ChangeType.BOTH;
        }
        return ListVariableState.compareLocations(entity, oldEntity, index, oldIndex);
    }

    private static ChangeType compareLocations(Object entity, Object otherEntity, int index, int otherIndex) {
        if (entity != otherEntity) {
            return ChangeType.BOTH;
        }
        if (index != otherIndex) {
            return ChangeType.INDEX;
        }
        return ChangeType.NEITHER;
    }

    public ElementLocation getLocationInList(Object planningValue) {
        if (this.requiresLocationMap) {
            MutableLocationInList mutableLocationInList = this.elementLocationMap.get(planningValue);
            if (mutableLocationInList == null) {
                return ElementLocation.unassigned();
            }
            return mutableLocationInList.getLocationInList();
        }
        Object inverse = this.externalizedInverseProcessor.getInverseSingleton(planningValue);
        if (inverse == null) {
            return ElementLocation.unassigned();
        }
        return ElementLocation.of(inverse, this.externalizedIndexProcessor.getIndex(planningValue));
    }

    public Integer getIndex(Object planningValue) {
        if (this.externalizedIndexProcessor == null) {
            MutableLocationInList elementLocation = this.elementLocationMap.get(planningValue);
            if (elementLocation == null) {
                return null;
            }
            return elementLocation.getIndex();
        }
        return this.externalizedIndexProcessor.getIndex(planningValue);
    }

    public Object getInverseSingleton(Object planningValue) {
        if (this.externalizedInverseProcessor == null) {
            MutableLocationInList elementLocation = this.elementLocationMap.get(planningValue);
            if (elementLocation == null) {
                return null;
            }
            return elementLocation.getEntity();
        }
        return this.externalizedInverseProcessor.getInverseSingleton(planningValue);
    }

    public Object getPreviousElement(Object element) {
        if (this.externalizedPreviousElementProcessor == null) {
            MutableLocationInList mutableLocationInList = this.elementLocationMap.get(element);
            if (mutableLocationInList == null) {
                return null;
            }
            int index = mutableLocationInList.getIndex();
            if (index == 0) {
                return null;
            }
            return this.sourceVariableDescriptor.getValue(mutableLocationInList.getEntity()).get(index - 1);
        }
        return this.externalizedPreviousElementProcessor.getElement(element);
    }

    public Object getNextElement(Object element) {
        if (this.externalizedNextElementProcessor == null) {
            MutableLocationInList mutableLocationInList = this.elementLocationMap.get(element);
            if (mutableLocationInList == null) {
                return null;
            }
            Object list = this.sourceVariableDescriptor.getValue(mutableLocationInList.getEntity());
            int index = mutableLocationInList.getIndex();
            if (index == list.size() - 1) {
                return null;
            }
            return list.get(index + 1);
        }
        return this.externalizedNextElementProcessor.getElement(element);
    }

    public int getUnassignedCount() {
        return this.unassignedCount;
    }

    private static final class MutableLocationInList {
        private Object entity;
        private int index;
        private LocationInList locationInList;

        public MutableLocationInList(Object entity, int index) {
            this.entity = entity;
            this.index = index;
        }

        public Object getEntity() {
            return this.entity;
        }

        public void setEntity(Object entity) {
            this.entity = entity;
            this.locationInList = null;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
            this.locationInList = null;
        }

        public LocationInList getLocationInList() {
            if (this.locationInList == null) {
                this.locationInList = ElementLocation.of(this.entity, this.index);
            }
            return this.locationInList;
        }
    }

    private static enum ChangeType {
        BOTH(true, true),
        INDEX(false, true),
        NEITHER(false, false);

        final boolean anythingChanged;
        final boolean entityChanged;
        final boolean indexChanged;

        private ChangeType(boolean entityChanged, boolean indexChanged) {
            this.anythingChanged = entityChanged || indexChanged;
            this.entityChanged = entityChanged;
            this.indexChanged = indexChanged;
        }
    }
}

