/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReflectionHelper {
    private static final String PROPERTY_ACCESSOR_PREFIX_GET = "get";
    private static final String PROPERTY_ACCESSOR_PREFIX_IS = "is";
    private static final String[] PROPERTY_ACCESSOR_PREFIXES = new String[]{"get", "is"};
    private static final String PROPERTY_MUTATOR_PREFIX = "set";

    public static String getGetterPropertyName(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            for (String prefix : PROPERTY_ACCESSOR_PREFIXES) {
                if (!methodName.startsWith(prefix)) continue;
                return ReflectionHelper.decapitalizePropertyName(methodName.substring(prefix.length()));
            }
        }
        return null;
    }

    private static String decapitalizePropertyName(String propertyName) {
        if (propertyName.isEmpty() || ReflectionHelper.startsWithSeveralUpperCaseLetters(propertyName)) {
            return propertyName;
        }
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }

    private static boolean startsWithSeveralUpperCaseLetters(String propertyName) {
        return propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(0)) && Character.isUpperCase(propertyName.charAt(1));
    }

    public static boolean isGetterMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String methodName = method.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET) && method.getReturnType() != Void.TYPE) {
            return true;
        }
        return methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS) && method.getReturnType() == Boolean.TYPE;
    }

    public static boolean hasGetterMethod(Class<?> containingClass, String propertyName) {
        return ReflectionHelper.getGetterMethod(containingClass, propertyName) != null;
    }

    public static Method getGetterMethod(Class<?> containingClass, String propertyName) {
        String capitalizedPropertyName = ReflectionHelper.capitalizePropertyName(propertyName);
        String getterName = PROPERTY_ACCESSOR_PREFIX_GET + capitalizedPropertyName;
        try {
            return containingClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String isserName = PROPERTY_ACCESSOR_PREFIX_IS + capitalizedPropertyName;
            try {
                Method method = containingClass.getMethod(isserName, new Class[0]);
                if (method.getReturnType() == Boolean.TYPE) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
            return null;
        }
    }

    private static String capitalizePropertyName(String propertyName) {
        if (propertyName.isEmpty() || Character.isUpperCase(propertyName.charAt(0))) {
            return propertyName;
        }
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static boolean hasField(Class<?> containingClass, String fieldName) {
        return ReflectionHelper.getField(containingClass, fieldName) != null;
    }

    public static Field getField(Class<?> containingClass, String fieldName) {
        try {
            return containingClass.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> containingClass, Class<?> propertyType, String propertyName) {
        String setterName = PROPERTY_MUTATOR_PREFIX + ReflectionHelper.capitalizePropertyName(propertyName);
        try {
            return containingClass.getMethod(setterName, propertyType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> containingClass, String propertyName) {
        String setterName = PROPERTY_MUTATOR_PREFIX + ReflectionHelper.capitalizePropertyName(propertyName);
        Object[] methods = (Method[])Arrays.stream(containingClass.getMethods()).filter(method -> method.getName().equals(setterName)).toArray(Method[]::new);
        if (methods.length == 0) {
            return null;
        }
        if (methods.length > 1) {
            throw new IllegalStateException("The containingClass (" + String.valueOf(containingClass) + ") has multiple setter methods (" + Arrays.toString(methods) + ") with the propertyName (" + propertyName + ").");
        }
        return methods[0];
    }

    public static boolean isMethodOverwritten(Method parentMethod, Class<?> childClass) {
        Method leafMethod;
        try {
            leafMethod = childClass.getDeclaredMethod(parentMethod.getName(), parentMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return !leafMethod.getDeclaringClass().equals(parentMethod.getClass());
    }

    public static void assertGetterMethod(Method getterMethod) {
        if (getterMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (%s) must not have any parameters (%s).".formatted(getterMethod, Arrays.toString(getterMethod.getParameterTypes())));
        }
        String methodName = getterMethod.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET)) {
            if (getterMethod.getReturnType() == Void.TYPE) {
                throw new IllegalStateException("The getterMethod (%s) must have a non-void return type (%s).".formatted(getterMethod, getterMethod.getReturnType()));
            }
        } else if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS)) {
            if (getterMethod.getReturnType() != Boolean.TYPE) {
                throw new IllegalStateException("The getterMethod (%s) must have a primitive boolean return type (%s) or use another prefix in its methodName (%s).\nMaybe use '%s' instead of '%s'?".formatted(getterMethod, getterMethod.getReturnType(), methodName, PROPERTY_ACCESSOR_PREFIX_GET, PROPERTY_ACCESSOR_PREFIX_IS));
            }
        } else {
            throw new IllegalStateException("The getterMethod (%s) has a methodName (%s) that does not start with a valid prefix (%s).".formatted(getterMethod, methodName, Arrays.toString(PROPERTY_ACCESSOR_PREFIXES)));
        }
    }

    public static void assertGetterMethod(Method getterMethod, Class<? extends Annotation> annotationClass) {
        if (getterMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (%s) with a %s annotation must not have any parameters (%s).".formatted(getterMethod, annotationClass.getSimpleName(), Arrays.toString(getterMethod.getParameterTypes())));
        }
        String methodName = getterMethod.getName();
        if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_GET)) {
            if (getterMethod.getReturnType() == Void.TYPE) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a non-void return type (%s).".formatted(getterMethod, annotationClass.getSimpleName(), getterMethod.getReturnType()));
            }
        } else if (methodName.startsWith(PROPERTY_ACCESSOR_PREFIX_IS)) {
            if (getterMethod.getReturnType() != Boolean.TYPE) {
                throw new IllegalStateException("The getterMethod (%s) with a %s annotation must have a primitive boolean return type (%s) or use another prefix in its methodName (%s).\nMaybe use '%s' instead of '%s'?".formatted(getterMethod, annotationClass.getSimpleName(), getterMethod.getReturnType(), methodName, PROPERTY_ACCESSOR_PREFIX_GET, PROPERTY_ACCESSOR_PREFIX_IS));
            }
        } else {
            throw new IllegalStateException("The getterMethod (%s) with a %s annotation has a methodName (%s) that does not start with a valid prefix (%s).".formatted(getterMethod, annotationClass.getSimpleName(), methodName, Arrays.toString(PROPERTY_ACCESSOR_PREFIXES)));
        }
    }

    public static void assertReadMethod(Method readMethod) {
        if (readMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The readMethod (%s) must not have any parameters (%s).".formatted(readMethod, Arrays.toString(readMethod.getParameterTypes())));
        }
        if (readMethod.getReturnType() == Void.TYPE) {
            throw new IllegalStateException("The readMethod (%s) must have a non-void return type (%s).".formatted(readMethod, readMethod.getReturnType()));
        }
    }

    public static void assertReadMethod(Method readMethod, Class<? extends Annotation> annotationClass) {
        if (readMethod.getParameterTypes().length != 0) {
            throw new IllegalStateException("The readMethod (%s) with a %s annotation must not have any parameters (%s).".formatted(readMethod, annotationClass.getSimpleName(), Arrays.toString(readMethod.getParameterTypes())));
        }
        if (readMethod.getReturnType() == Void.TYPE) {
            throw new IllegalStateException("The readMethod (%s) with a %s annotation must have a non-void return type (%s).".formatted(readMethod, annotationClass.getSimpleName(), readMethod.getReturnType()));
        }
    }

    public static <Value_> List<Value_> transformArrayToList(Object arrayObject) {
        if (arrayObject == null) {
            return null;
        }
        int arrayLength = Array.getLength(arrayObject);
        ArrayList<Object> list = new ArrayList<Object>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            list.add(Array.get(arrayObject, i));
        }
        return list;
    }

    private ReflectionHelper() {
    }
}

