/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardsoft;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HardSoftScore
implements Score<HardSoftScore> {
    public static final @NonNull HardSoftScore ZERO = new HardSoftScore(0, 0, 0);
    public static final @NonNull HardSoftScore ONE_HARD = new HardSoftScore(0, 1, 0);
    public static final @NonNull HardSoftScore ONE_SOFT = new HardSoftScore(0, 0, 1);
    private static final @NonNull HardSoftScore MINUS_ONE_SOFT = new HardSoftScore(0, 0, -1);
    private static final @NonNull HardSoftScore MINUS_ONE_HARD = new HardSoftScore(0, -1, 0);
    private final int initScore;
    private final int hardScore;
    private final int softScore;

    public static @NonNull HardSoftScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardSoftScore.class, scoreString, "hard", "soft");
        int initScore = ScoreUtil.parseInitScore(HardSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = ScoreUtil.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[1]);
        int softScore = ScoreUtil.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[2]);
        return HardSoftScore.ofUninitialized(initScore, hardScore, softScore);
    }

    public static @NonNull HardSoftScore ofUninitialized(int initScore, int hardScore, int softScore) {
        if (initScore == 0) {
            return HardSoftScore.of(hardScore, softScore);
        }
        return new HardSoftScore(initScore, hardScore, softScore);
    }

    public static @NonNull HardSoftScore of(int hardScore, int softScore) {
        if (hardScore == 0) {
            if (softScore == -1) {
                return MINUS_ONE_SOFT;
            }
            if (softScore == 0) {
                return ZERO;
            }
            if (softScore == 1) {
                return ONE_SOFT;
            }
        } else if (softScore == 0) {
            if (hardScore == 1) {
                return ONE_HARD;
            }
            if (hardScore == -1) {
                return MINUS_ONE_HARD;
            }
        }
        return new HardSoftScore(0, hardScore, softScore);
    }

    public static @NonNull HardSoftScore ofHard(int hardScore) {
        if (hardScore == -1) {
            return MINUS_ONE_HARD;
        }
        if (hardScore == 0) {
            return ZERO;
        }
        if (hardScore == 1) {
            return ONE_HARD;
        }
        return new HardSoftScore(0, hardScore, 0);
    }

    public static @NonNull HardSoftScore ofSoft(int softScore) {
        if (softScore == -1) {
            return MINUS_ONE_SOFT;
        }
        if (softScore == 0) {
            return ZERO;
        }
        if (softScore == 1) {
            return ONE_SOFT;
        }
        return new HardSoftScore(0, 0, softScore);
    }

    private HardSoftScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private HardSoftScore(int initScore, int hardScore, int softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public int hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public int getHardScore() {
        return this.hardScore;
    }

    public int softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public @NonNull HardSoftScore withInitScore(int newInitScore) {
        return HardSoftScore.ofUninitialized(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public @NonNull HardSoftScore add(@NonNull HardSoftScore addend) {
        return HardSoftScore.ofUninitialized(this.initScore + addend.initScore(), this.hardScore + addend.hardScore(), this.softScore + addend.softScore());
    }

    @Override
    public @NonNull HardSoftScore subtract(@NonNull HardSoftScore subtrahend) {
        return HardSoftScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.hardScore - subtrahend.hardScore(), this.softScore - subtrahend.softScore());
    }

    @Override
    public @NonNull HardSoftScore multiply(double multiplicand) {
        return HardSoftScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public @NonNull HardSoftScore divide(double divisor) {
        return HardSoftScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public @NonNull HardSoftScore power(double exponent) {
        return HardSoftScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public @NonNull HardSoftScore abs() {
        return HardSoftScore.ofUninitialized(Math.abs(this.initScore), Math.abs(this.hardScore), Math.abs(this.softScore));
    }

    @Override
    public @NonNull HardSoftScore zero() {
        return ZERO;
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardSoftScore) {
            HardSoftScore other = (HardSoftScore)o;
            return this.initScore == other.initScore() && this.hardScore == other.hardScore() && this.softScore == other.softScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.softScore);
    }

    @Override
    public int compareTo(@NonNull HardSoftScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        if (this.hardScore != other.hardScore()) {
            return Integer.compare(this.hardScore, other.hardScore());
        }
        return Integer.compare(this.softScore, other.softScore());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "hard", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.softScore + "soft";
    }
}

