/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public interface ScoreExplanation<Solution_, Score_ extends Score<Score_>> {
    public @NonNull Solution_ getSolution();

    public @NonNull Score_ getScore();

    public @NonNull String getSummary();

    public @NonNull Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap();

    public @NonNull List<ConstraintJustification> getJustificationList();

    default public <ConstraintJustification_ extends ConstraintJustification> @NonNull List<ConstraintJustification_> getJustificationList(@NonNull Class<? extends ConstraintJustification_> constraintJustificationClass) {
        return this.getJustificationList().stream().filter(constraintJustification -> constraintJustificationClass.isAssignableFrom(constraintJustification.getClass())).map(constraintJustification -> constraintJustification).collect(Collectors.toList());
    }

    public @NonNull Map<Object, Indictment<Score_>> getIndictmentMap();
}

