/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListener;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleSupport;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhase<Solution_>
implements Phase<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final int phaseIndex;
    protected final String logIndentation;
    protected final Termination<Solution_> phaseTermination;
    protected final boolean assertStepScoreFromScratch;
    protected final boolean assertExpectedStepScore;
    protected final boolean assertShadowVariablesAreNotStaleAfterStep;
    protected PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected AbstractSolver<Solution_> solver;

    protected AbstractPhase(Builder<Solution_> builder) {
        this.phaseIndex = builder.phaseIndex;
        this.logIndentation = builder.logIndentation;
        this.phaseTermination = builder.phaseTermination;
        this.assertStepScoreFromScratch = builder.assertStepScoreFromScratch;
        this.assertExpectedStepScore = builder.assertExpectedStepScore;
        this.assertShadowVariablesAreNotStaleAfterStep = builder.assertShadowVariablesAreNotStaleAfterStep;
    }

    public int getPhaseIndex() {
        return this.phaseIndex;
    }

    public Termination<Solution_> getPhaseTermination() {
        return this.phaseTermination;
    }

    public AbstractSolver<Solution_> getSolver() {
        return this.solver;
    }

    public void setSolver(AbstractSolver<Solution_> solver) {
        this.solver = solver;
    }

    public boolean isAssertStepScoreFromScratch() {
        return this.assertStepScoreFromScratch;
    }

    public boolean isAssertExpectedStepScore() {
        return this.assertExpectedStepScore;
    }

    public boolean isAssertShadowVariablesAreNotStaleAfterStep() {
        return this.assertShadowVariablesAreNotStaleAfterStep;
    }

    public abstract String getPhaseTypeString();

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.phaseTermination.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.phaseTermination.solvingEnded(solverScope);
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        phaseScope.startingNow();
        phaseScope.reset();
        this.solver.phaseStarted(phaseScope);
        this.phaseTermination.phaseStarted(phaseScope);
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.solver.phaseEnded(phaseScope);
        this.phaseTermination.phaseEnded(phaseScope);
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        this.solver.stepStarted(stepScope);
        this.phaseTermination.stepStarted(stepScope);
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
    }

    protected <Score_ extends Score<Score_>> void calculateWorkingStepScore(AbstractStepScope<Solution_> stepScope, Object completedAction) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        Object score = phaseScope.calculateScore();
        stepScope.setScore((Score<?>)score);
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), completedAction);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            phaseScope.assertShadowVariablesAreNotStale(stepScope.getScore(), completedAction);
        }
    }

    protected <Score_ extends Score<Score_>> void predictWorkingStepScore(AbstractStepScope<Solution_> stepScope, Object completedAction) {
        AbstractPhaseScope<Solution_> phaseScope = stepScope.getPhaseScope();
        phaseScope.getSolutionDescriptor().setScore(phaseScope.getWorkingSolution(), stepScope.getScore());
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertPredictedScoreFromScratch(stepScope.getScore(), completedAction);
        }
        if (this.assertExpectedStepScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), completedAction);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            phaseScope.assertShadowVariablesAreNotStale(stepScope.getScore(), completedAction);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.solver.stepEnded(stepScope);
        this.collectMetrics(stepScope);
        this.phaseTermination.stepEnded(stepScope);
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
    }

    private void collectMetrics(AbstractStepScope<Solution_> stepScope) {
        SolverScope<Solution_> solverScope = stepScope.getPhaseScope().getSolverScope();
        if (solverScope.isMetricEnabled(SolverMetric.STEP_SCORE) && stepScope.getScore().isSolutionInitialized()) {
            SolverMetric.registerScoreMetrics(SolverMetric.STEP_SCORE, solverScope.getMonitoringTags(), solverScope.getScoreDefinition(), solverScope.getStepScoreMap(), stepScope.getScore());
        }
    }

    @Override
    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    @Override
    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }

    protected void assertWorkingSolutionInitialized(AbstractPhaseScope<Solution_> phaseScope) {
        if (!phaseScope.getStartingScore().isSolutionInitialized()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            SolutionDescriptor solutionDescriptor = scoreDirector.getSolutionDescriptor();
            Object workingSolution = scoreDirector.getWorkingSolution();
            solutionDescriptor.visitAllEntities(workingSolution, entity -> {
                EntityDescriptor entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
                if (!entityDescriptor.isEntityInitializedOrPinned(scoreDirector, entity)) {
                    String variableRef = null;
                    for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                        if (variableDescriptor.isInitialized(entity)) continue;
                        variableRef = variableDescriptor.getSimpleEntityAndVariableName();
                        break;
                    }
                    throw new IllegalStateException(this.getPhaseTypeString() + " phase (" + this.phaseIndex + ") needs to start from an initialized solution, but the planning variable (" + variableRef + ") is uninitialized for the entity (" + entity + ").\nMaybe there is no Construction Heuristic configured before this phase to initialize the solution.\nOr maybe the getter/setters of your planning variables in your domain classes aren't implemented correctly.");
                }
            });
        }
    }

    protected static abstract class Builder<Solution_> {
        private final int phaseIndex;
        private final String logIndentation;
        private final Termination<Solution_> phaseTermination;
        private boolean assertStepScoreFromScratch = false;
        private boolean assertExpectedStepScore = false;
        private boolean assertShadowVariablesAreNotStaleAfterStep = false;

        protected Builder(int phaseIndex, String logIndentation, Termination<Solution_> phaseTermination) {
            this.phaseIndex = phaseIndex;
            this.logIndentation = logIndentation;
            this.phaseTermination = phaseTermination;
        }

        public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
            this.assertStepScoreFromScratch = assertStepScoreFromScratch;
        }

        public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
            this.assertExpectedStepScore = assertExpectedStepScore;
        }

        public void setAssertShadowVariablesAreNotStaleAfterStep(boolean assertShadowVariablesAreNotStaleAfterStep) {
            this.assertShadowVariablesAreNotStaleAfterStep = assertShadowVariablesAreNotStaleAfterStep;
        }

        protected abstract AbstractPhase<Solution_> build();
    }
}

