/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.PillarSwapMoveSelector;
import java.util.List;
import java.util.Objects;

public class PillarSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, PillarSwapMoveSelectorConfig> {
    public PillarSwapMoveSelectorFactory(PillarSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        PillarSelectorConfig leftPillarSelectorConfig = Objects.requireNonNullElseGet(((PillarSwapMoveSelectorConfig)this.config).getPillarSelectorConfig(), PillarSelectorConfig::new);
        PillarSelectorConfig rightPillarSelectorConfig = Objects.requireNonNullElse(((PillarSwapMoveSelectorConfig)this.config).getSecondaryPillarSelectorConfig(), leftPillarSelectorConfig);
        PillarSelector<Solution_> leftPillarSelector = this.buildPillarSelector(leftPillarSelectorConfig, configPolicy, minimumCacheType, randomSelection);
        PillarSelector<Solution_> rightPillarSelector = this.buildPillarSelector(rightPillarSelectorConfig, configPolicy, minimumCacheType, randomSelection);
        List<GenuineVariableDescriptor<Solution_>> variableDescriptorList = this.deduceVariableDescriptorList(leftPillarSelector.getEntityDescriptor(), ((PillarSwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
        return new PillarSwapMoveSelector<Solution_>(leftPillarSelector, rightPillarSelector, variableDescriptorList, randomSelection);
    }

    private PillarSelector<Solution_> buildPillarSelector(PillarSelectorConfig pillarSelectorConfig, HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        return PillarSelectorFactory.create(pillarSelectorConfig).buildPillarSelector(configPolicy, ((PillarSwapMoveSelectorConfig)this.config).getSubPillarType(), ((PillarSwapMoveSelectorConfig)this.config).getSubPillarSequenceComparatorClass(), minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection), ((PillarSwapMoveSelectorConfig)this.config).getVariableNameIncludeList());
    }
}

