/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.decorator;

import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SelectedCountLimitMoveSelector<Solution_>
extends AbstractMoveSelector<Solution_> {
    protected final MoveSelector<Solution_> childMoveSelector;
    protected final long selectedCountLimit;

    public SelectedCountLimitMoveSelector(MoveSelector<Solution_> childMoveSelector, long selectedCountLimit) {
        this.childMoveSelector = childMoveSelector;
        this.selectedCountLimit = selectedCountLimit;
        if (selectedCountLimit < 0L) {
            throw new IllegalArgumentException("The selector (" + this + ") has a negative selectedCountLimit (" + selectedCountLimit + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize() {
        long childSize = this.childMoveSelector.getSize();
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new SelectedCountLimitMoveIterator(this.childMoveSelector.iterator());
    }

    public String toString() {
        return "SelectedCountLimit(" + this.childMoveSelector + ")";
    }

    private class SelectedCountLimitMoveIterator
    extends SelectionIterator<Move<Solution_>> {
        private final Iterator<Move<Solution_>> childMoveIterator;
        private long selectedSize;

        public SelectedCountLimitMoveIterator(Iterator<Move<Solution_>> childMoveIterator) {
            this.childMoveIterator = childMoveIterator;
            this.selectedSize = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.selectedSize < SelectedCountLimitMoveSelector.this.selectedCountLimit && this.childMoveIterator.hasNext();
        }

        @Override
        public Move<Solution_> next() {
            if (this.selectedSize >= SelectedCountLimitMoveSelector.this.selectedCountLimit) {
                throw new NoSuchElementException();
            }
            ++this.selectedSize;
            return this.childMoveIterator.next();
        }
    }
}

