/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list.nearby;

import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementRef;
import java.util.Iterator;
import java.util.function.Function;

final class OriginalNearbyDestinationIterator
extends SelectionIterator<ElementRef> {
    private final NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix;
    private final Iterator<?> replayingOriginValueIterator;
    private final Function<Iterator<?>, Object> originFunction;
    private final Function<Object, ElementRef> elementRefFunction;
    private final long childSize;
    private boolean originSelected = false;
    private boolean originIsNotEmpty;
    private Object origin;
    private int nextNearbyIndex;

    public OriginalNearbyDestinationIterator(NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix, Iterator<?> replayingOriginValueIterator, Function<Object, ElementRef> elementRefFunction, long childSize) {
        this(nearbyDistanceMatrix, replayingOriginValueIterator, Iterator::next, elementRefFunction, childSize);
    }

    public OriginalNearbyDestinationIterator(NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix, Iterator<?> replayingOriginValueIterator, Function<Iterator<?>, Object> originFunction, Function<Object, ElementRef> elementRefFunction, long childSize) {
        this.nearbyDistanceMatrix = nearbyDistanceMatrix;
        this.replayingOriginValueIterator = replayingOriginValueIterator;
        this.originFunction = originFunction;
        this.elementRefFunction = elementRefFunction;
        this.childSize = childSize;
        this.nextNearbyIndex = 0;
    }

    private void selectOrigin() {
        if (this.originSelected) {
            return;
        }
        this.originIsNotEmpty = this.replayingOriginValueIterator.hasNext();
        this.origin = this.originFunction.apply(this.replayingOriginValueIterator);
        this.originSelected = true;
    }

    @Override
    public boolean hasNext() {
        this.selectOrigin();
        return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
    }

    @Override
    public ElementRef next() {
        this.selectOrigin();
        Object next = this.nearbyDistanceMatrix.getDestination(this.origin, this.nextNearbyIndex);
        ++this.nextNearbyIndex;
        return this.elementRefFunction.apply(next);
    }
}

