/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.nearby;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.AbstractNearbySelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.RandomNearbyIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.nearby.EntityNearbyDistanceMatrixDemand;
import ai.timefold.solver.core.impl.heuristic.selector.entity.nearby.OriginalNearbyEntityIterator;
import java.util.Iterator;
import java.util.ListIterator;

public final class NearEntityNearbyEntitySelector<Solution_>
extends AbstractNearbySelector<Solution_, EntitySelector<Solution_>, EntitySelector<Solution_>>
implements EntitySelector<Solution_> {
    private final boolean discardNearbyIndexZero = true;

    public NearEntityNearbyEntitySelector(EntitySelector<Solution_> childEntitySelector, EntitySelector<Solution_> originEntitySelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childEntitySelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
        if (!childEntitySelector.getEntityDescriptor().getEntityClass().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") has an entityClass (" + childEntitySelector.getEntityDescriptor().getEntityClass() + ") which is not a superclass of the originEntitySelector's entityClass (" + originEntitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
    }

    @Override
    protected EntitySelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingEntitySelector)) {
            throw new IllegalStateException("Impossible state: Nearby entity selector (" + this + ") did not receive a replaying entity selector (" + uncastReplayingSelector + ").");
        }
        return (EntitySelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new EntityNearbyDistanceMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (EntitySelector)this.childSelector, (EntitySelector)this.replayingSelector, origin -> this.computeDestinationSize(((EntitySelector)this.childSelector).getSize()));
    }

    private int computeDestinationSize(long childSize) {
        int destinationSize = (int)childSize;
        if (this.randomSelection) {
            int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
            if (overallSizeMaximum != Integer.MAX_VALUE) {
                ++overallSizeMaximum;
            }
            if (destinationSize > overallSizeMaximum) {
                destinationSize = overallSizeMaximum;
            }
        }
        return destinationSize;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return ((EntitySelector)this.childSelector).getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public long getSize() {
        return ((EntitySelector)this.childSelector).getSize() - 1L;
    }

    @Override
    public Iterator<Object> iterator() {
        Iterator<Object> replayingOriginEntityIterator = ((EntitySelector)this.replayingSelector).iterator();
        if (!this.randomSelection) {
            return new OriginalNearbyEntityIterator(this.nearbyDistanceMatrix, replayingOriginEntityIterator, ((EntitySelector)this.childSelector).getSize(), true);
        }
        return new RandomNearbyIterator(this.nearbyDistanceMatrix, this.nearbyRandom, this.workingRandom, replayingOriginEntityIterator, ((EntitySelector)this.childSelector).getSize(), true);
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return ((EntitySelector)this.childSelector).endingIterator();
    }
}

