/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.mimic;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionListIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class MimicRecordingEntitySelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntityMimicRecorder<Solution_>,
EntitySelector<Solution_> {
    private final EntitySelector<Solution_> childEntitySelector;
    private final List<MimicReplayingEntitySelector<Solution_>> replayingEntitySelectorList;

    public MimicRecordingEntitySelector(EntitySelector<Solution_> childEntitySelector) {
        this.childEntitySelector = childEntitySelector;
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
        this.replayingEntitySelectorList = new ArrayList<MimicReplayingEntitySelector<Solution_>>();
    }

    @Override
    public void addMimicReplayingEntitySelector(MimicReplayingEntitySelector<Solution_> replayingEntitySelector) {
        this.replayingEntitySelectorList.add(replayingEntitySelector);
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new RecordingEntityIterator(this.childEntitySelector.iterator());
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.childEntitySelector.endingIterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new RecordingEntityListIterator(this.childEntitySelector.listIterator());
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new RecordingEntityListIterator(this.childEntitySelector.listIterator(index));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MimicRecordingEntitySelector that = (MimicRecordingEntitySelector)other;
        return Objects.equals(this.childEntitySelector, that.childEntitySelector) && Objects.equals(this.replayingEntitySelectorList.size(), that.replayingEntitySelectorList.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.replayingEntitySelectorList.size());
    }

    public String toString() {
        return "Recording(" + this.childEntitySelector + ")";
    }

    private class RecordingEntityListIterator
    extends SelectionListIterator<Object> {
        private final ListIterator<Object> childEntityIterator;

        public RecordingEntityListIterator(ListIterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childEntityIterator.hasNext();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public Object next() {
            Object next = this.childEntityIterator.next();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedNext(next);
            }
            return next;
        }

        @Override
        public boolean hasPrevious() {
            boolean hasPrevious = this.childEntityIterator.hasPrevious();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedHasNext(hasPrevious);
            }
            return hasPrevious;
        }

        @Override
        public Object previous() {
            Object previous = this.childEntityIterator.previous();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedNext(previous);
            }
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.childEntityIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.childEntityIterator.previousIndex();
        }
    }

    private class RecordingEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;

        public RecordingEntityIterator(Iterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childEntityIterator.hasNext();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public Object next() {
            Object next = this.childEntityIterator.next();
            for (MimicReplayingEntitySelector replayingEntitySelector : MimicRecordingEntitySelector.this.replayingEntitySelectorList) {
                replayingEntitySelector.recordedNext(next);
            }
            return next;
        }
    }
}

