/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.nearby;

import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import java.util.Iterator;
import java.util.Random;

public final class RandomNearbyIterator
extends SelectionIterator<Object> {
    private final NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix;
    private final NearbyRandom nearbyRandom;
    private final Random workingRandom;
    private final Iterator<Object> replayingIterator;
    private final int nearbySize;
    private final boolean discardNearbyIndexZero;
    private Object origin;

    public RandomNearbyIterator(NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix, NearbyRandom nearbyRandom, Random workingRandom, Iterator<Object> replayingIterator, long childSize, boolean discardNearbyIndexZero) {
        this.nearbyDistanceMatrix = nearbyDistanceMatrix;
        this.nearbyRandom = nearbyRandom;
        this.workingRandom = workingRandom;
        this.replayingIterator = replayingIterator;
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.nearbySize = (int)childSize - (discardNearbyIndexZero ? 1 : 0);
        this.discardNearbyIndexZero = discardNearbyIndexZero;
    }

    @Override
    public boolean hasNext() {
        return (this.origin != null || this.replayingIterator.hasNext()) && this.nearbySize > 0;
    }

    @Override
    public Object next() {
        if (this.replayingIterator.hasNext()) {
            this.origin = this.replayingIterator.next();
        }
        int nearbyIndex = this.nearbyRandom.nextInt(this.workingRandom, this.nearbySize);
        if (this.discardNearbyIndexZero) {
            ++nearbyIndex;
        }
        return this.nearbyDistanceMatrix.getDestination(this.origin, nearbyIndex);
    }
}

