/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public final class ComparatorSelectionSorter<Solution_, T>
implements SelectionSorter<Solution_, T> {
    private final Comparator<T> appliedComparator;

    public ComparatorSelectionSorter(Comparator<T> comparator, SelectionSorterOrder selectionSorterOrder) {
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedComparator = comparator;
                break;
            }
            case DESCENDING: {
                this.appliedComparator = Collections.reverseOrder(comparator);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + selectionSorterOrder + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector<Solution_> scoreDirector, List<T> selectionList) {
        selectionList.sort(this.appliedComparator);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ComparatorSelectionSorter that = (ComparatorSelectionSorter)other;
        return Objects.equals(this.appliedComparator, that.appliedComparator);
    }

    public int hashCode() {
        return Objects.hash(this.appliedComparator);
    }
}

