/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.index;

import ai.timefold.solver.core.api.domain.variable.ListVariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.List;
import java.util.Objects;

public class IndexVariableListener<Solution_>
implements ListVariableListener<Solution_, Object, Object>,
IndexVariableSupply {
    protected final IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private static final int NEVER_QUIT_EARLY = Integer.MAX_VALUE;

    public IndexVariableListener(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.updateIndexes((InnerScoreDirector)scoreDirector, entity, 0, Integer.MAX_VALUE);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object element : listVariable) {
            innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, null);
            innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(ScoreDirector<Solution_> scoreDirector, Object element) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, null);
        innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        this.updateIndexes(innerScoreDirector, entity, fromIndex, toIndex);
    }

    private void updateIndexes(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity, int fromIndex, int toIndex) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (int i = fromIndex; i < listVariable.size(); ++i) {
            Object element = listVariable.get(i);
            Integer oldIndex = this.shadowVariableDescriptor.getValue(element);
            if (!Objects.equals(oldIndex, i)) {
                scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
                this.shadowVariableDescriptor.setValue(element, i);
                scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
                continue;
            }
            if (i < toIndex) continue;
            return;
        }
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

