/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.descriptor;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ListVariableDescriptor<Solution_>
extends GenuineVariableDescriptor<Solution_> {
    public ListVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    protected void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningListVariable planningVariableAnnotation = this.variableMemberAccessor.getAnnotation(PlanningListVariable.class);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation.valueRangeProviderRefs());
    }

    @Override
    protected void processValueRangeRefs(DescriptorPolicy descriptorPolicy, String[] valueRangeProviderRefs) {
        List fromEntityValueRangeProviderRefs = Arrays.stream(valueRangeProviderRefs).filter(descriptorPolicy::hasFromEntityValueRangeProvider).collect(Collectors.toList());
        if (!fromEntityValueRangeProviderRefs.isEmpty()) {
            throw new IllegalArgumentException("@" + ValueRangeProvider.class.getSimpleName() + " on a @" + PlanningEntity.class.getSimpleName() + " is not supported with a list variable (" + this + ").\nMaybe move the valueRangeProvider" + (fromEntityValueRangeProviderRefs.size() > 1 ? "s" : "") + " (" + fromEntityValueRangeProviderRefs + ") from the entity class to the @" + PlanningSolution.class.getSimpleName() + " class.");
        }
        super.processValueRangeRefs(descriptorPolicy, valueRangeProviderRefs);
    }

    @Override
    public boolean isGenuineListVariable() {
        return true;
    }

    @Override
    public boolean isListVariable() {
        return true;
    }

    @Override
    public boolean isChained() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean acceptsValueType(Class<?> valueType) {
        return this.getElementType().isAssignableFrom(valueType);
    }

    public Class<?> getElementType() {
        return ConfigUtils.extractCollectionGenericTypeParameterStrictly("entityClass", this.entityDescriptor.getEntityClass(), this.variableMemberAccessor.getType(), this.variableMemberAccessor.getGenericType(), PlanningListVariable.class, this.variableMemberAccessor.getName());
    }

    @Override
    public boolean isInitialized(Object entity) {
        return true;
    }

    public List<Object> getListVariable(Object entity) {
        return (List)this.getValue(entity);
    }

    public Object removeElement(Object entity, int index) {
        return this.getListVariable(entity).remove(index);
    }

    public void addElement(Object entity, int index, Object element) {
        this.getListVariable(entity).add(index, element);
    }

    public Object getElement(Object entity, int index) {
        return this.getListVariable(entity).get(index);
    }

    public Object setElement(Object entity, int index, Object element) {
        return this.getListVariable(entity).set(index, element);
    }

    public int getListSize(Object entity) {
        return this.getListVariable(entity).size();
    }
}

