/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.constructionheuristic;

import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum ConstructionHeuristicType {
    FIRST_FIT,
    FIRST_FIT_DECREASING,
    WEAKEST_FIT,
    WEAKEST_FIT_DECREASING,
    STRONGEST_FIT,
    STRONGEST_FIT_DECREASING,
    ALLOCATE_ENTITY_FROM_QUEUE,
    ALLOCATE_TO_VALUE_FROM_QUEUE,
    CHEAPEST_INSERTION,
    ALLOCATE_FROM_POOL;


    public EntitySorterManner getDefaultEntitySorterManner() {
        switch (this) {
            case FIRST_FIT: 
            case WEAKEST_FIT: 
            case STRONGEST_FIT: {
                return EntitySorterManner.NONE;
            }
            case FIRST_FIT_DECREASING: 
            case WEAKEST_FIT_DECREASING: 
            case STRONGEST_FIT_DECREASING: {
                return EntitySorterManner.DECREASING_DIFFICULTY;
            }
            case ALLOCATE_ENTITY_FROM_QUEUE: 
            case ALLOCATE_TO_VALUE_FROM_QUEUE: 
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                return EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + this + ") is not implemented.");
    }

    public ValueSorterManner getDefaultValueSorterManner() {
        switch (this) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: {
                return ValueSorterManner.NONE;
            }
            case WEAKEST_FIT: 
            case WEAKEST_FIT_DECREASING: {
                return ValueSorterManner.INCREASING_STRENGTH;
            }
            case STRONGEST_FIT: 
            case STRONGEST_FIT_DECREASING: {
                return ValueSorterManner.DECREASING_STRENGTH;
            }
            case ALLOCATE_ENTITY_FROM_QUEUE: 
            case ALLOCATE_TO_VALUE_FROM_QUEUE: 
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                return ValueSorterManner.INCREASING_STRENGTH_IF_AVAILABLE;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + this + ") is not implemented.");
    }

    public static ConstructionHeuristicType[] getBluePrintTypes() {
        return new ConstructionHeuristicType[]{FIRST_FIT, FIRST_FIT_DECREASING, WEAKEST_FIT, WEAKEST_FIT_DECREASING, STRONGEST_FIT, STRONGEST_FIT_DECREASING, CHEAPEST_INSERTION};
    }
}

