/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.bendablebigdecimal;

import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public final class BendableBigDecimalScore
implements IBendableScore<BendableBigDecimalScore> {
    private final int initScore;
    private final BigDecimal[] hardScores;
    private final BigDecimal[] softScores;

    public static BendableBigDecimalScore parseScore(String scoreString) {
        String[][] scoreTokens = ScoreUtil.parseBendableScoreTokens(BendableBigDecimalScore.class, scoreString);
        int initScore = ScoreUtil.parseInitScore(BendableBigDecimalScore.class, scoreString, scoreTokens[0][0]);
        BigDecimal[] hardScores = new BigDecimal[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = ScoreUtil.parseLevelAsBigDecimal(BendableBigDecimalScore.class, scoreString, scoreTokens[1][i]);
        }
        BigDecimal[] softScores = new BigDecimal[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = ScoreUtil.parseLevelAsBigDecimal(BendableBigDecimalScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableBigDecimalScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public static BendableBigDecimalScore ofUninitialized(int initScore, BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(initScore, hardScores, softScores);
    }

    public static BendableBigDecimalScore of(BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(0, hardScores, softScores);
    }

    public static BendableBigDecimalScore zero(int hardLevelsSize, int softLevelsSize) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    public static BendableBigDecimalScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, BigDecimal hardScore) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        hardScores[hardLevel] = hardScore;
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    public static BendableBigDecimalScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, BigDecimal softScore) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        softScores[softLevel] = softScore;
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    private BendableBigDecimalScore() {
        this(Integer.MIN_VALUE, null, null);
    }

    private BendableBigDecimalScore(int initScore, BigDecimal[] hardScores, BigDecimal[] softScores) {
        this.initScore = initScore;
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public BigDecimal[] hardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    @Deprecated(forRemoval=true)
    public BigDecimal[] getHardScores() {
        return this.hardScores();
    }

    public BigDecimal[] softScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Deprecated(forRemoval=true)
    public BigDecimal[] getSoftScores() {
        return this.softScores();
    }

    @Override
    public int hardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal hardScore(int index) {
        return this.hardScores[index];
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getHardScore(int index) {
        return this.hardScore(index);
    }

    @Override
    public int softLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal softScore(int index) {
        return this.softScores[index];
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getSoftScore(int index) {
        return this.softScore(index);
    }

    @Override
    public BendableBigDecimalScore withInitScore(int newInitScore) {
        return new BendableBigDecimalScore(newInitScore, this.hardScores, this.softScores);
    }

    public BigDecimal hardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Deprecated(forRemoval=true)
    public BigDecimal getHardOrSoftScore(int index) {
        return this.hardOrSoftScore(index);
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (BigDecimal hardScore : this.hardScores) {
            if (hardScore.compareTo(BigDecimal.ZERO) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableBigDecimalScore add(BendableBigDecimalScore addend) {
        int i;
        this.validateCompatible(addend);
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].add(addend.hardScore(i));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].add(addend.softScore(i));
        }
        return new BendableBigDecimalScore(this.initScore + addend.initScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore subtract(BendableBigDecimalScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].subtract(subtrahend.hardScore(i));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].subtract(subtrahend.softScore(i));
        }
        return new BendableBigDecimalScore(this.initScore - subtrahend.initScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore multiply(double multiplicand) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal bigDecimalMultiplicand = BigDecimal.valueOf(multiplicand);
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].multiply(bigDecimalMultiplicand).setScale(this.hardScores[i].scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].multiply(bigDecimalMultiplicand).setScale(this.softScores[i].scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore divide(double divisor) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal bigDecimalDivisor = BigDecimal.valueOf(divisor);
        for (i = 0; i < newHardScores.length; ++i) {
            BigDecimal hardScore = this.hardScores[i];
            newHardScores[i] = hardScore.divide(bigDecimalDivisor, hardScore.scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            BigDecimal softScore = this.softScores[i];
            newSoftScores[i] = softScore.divide(bigDecimalDivisor, softScore.scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore power(double exponent) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal actualExponent = BigDecimal.valueOf(exponent);
        for (i = 0; i < newHardScores.length; ++i) {
            BigDecimal hardScore = this.hardScores[i];
            newHardScores[i] = hardScore.pow(actualExponent.intValue()).setScale(hardScore.scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            BigDecimal softScore = this.softScores[i];
            newSoftScores[i] = softScore.pow(actualExponent.intValue()).setScale(softScore.scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore negate() {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].negate();
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].negate();
        }
        return new BendableBigDecimalScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore abs() {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].abs();
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].abs();
        }
        return new BendableBigDecimalScore(Math.abs(this.initScore), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore zero() {
        return BendableBigDecimalScore.zero(this.hardLevelsSize(), this.softLevelsSize());
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableBigDecimalScore) {
            int i;
            BendableBigDecimalScore other = (BendableBigDecimalScore)o;
            if (this.hardLevelsSize() != other.hardLevelsSize() || this.softLevelsSize() != other.softLevelsSize()) {
                return false;
            }
            if (this.initScore != other.initScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i].stripTrailingZeros().equals(other.hardScore(i).stripTrailingZeros())) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i].stripTrailingZeros().equals(other.softScore(i).stripTrailingZeros())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int[] scoreHashCodes = Stream.concat(Arrays.stream(this.hardScores), Arrays.stream(this.softScores)).map(BigDecimal::stripTrailingZeros).mapToInt(BigDecimal::hashCode).toArray();
        return Objects.hash(this.initScore, Arrays.hashCode(scoreHashCodes));
    }

    @Override
    public int compareTo(BendableBigDecimalScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int hardScoreComparison = this.hardScores[i].compareTo(other.hardScore(i));
            if (hardScoreComparison == 0) continue;
            return hardScoreComparison;
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int softScoreComparison = this.softScores[i].compareTo(other.softScore(i));
            if (softScoreComparison == 0) continue;
            return softScoreComparison;
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildBendableShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s.append(ScoreUtil.getInitPrefix(this.initScore));
        s.append("[");
        boolean first = true;
        for (BigDecimal hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (BigDecimal softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableBigDecimalScore other) {
        if (this.hardLevelsSize() != other.hardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.hardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.hardLevelsSize() + ").");
        }
        if (this.softLevelsSize() != other.softLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.softLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.softLevelsSize() + ").");
        }
    }
}

