package ai.timefold.solver.core.api.domain.common;

import ai.timefold.solver.core.api.domain.variable.PlanningVariable;

/**
 * Determines how members (fields and methods) of the domain (for example the {@link PlanningVariable planner variable})
 * are accessed.
 */
public enum DomainAccessType {
    /**
     * Use reflection to read/write members (fields and methods) of the domain.
     * <p>
     * When used in a modulepath, the module must be open.
     * When used in GraalVM, the domain must be open for reflection.
     * <p>
     * This is the default, except with timefold-solver-quarkus.
     */
    REFLECTION,
    /**
     * Use Gizmo generated bytecode to access members (fields and methods) to avoid reflection
     * for additional performance.
     * <p>
     * With timefold-solver-quarkus, this bytecode is generated at build time
     * and it supports planning annotations on non-public members too.
     * <p>
     * Without timefold-solver-quarkus, this bytecode is generated at bootstrap runtime
     * and you must add Gizmo in your classpath or modulepath
     * and use planning annotations on public members only.
     */
    GIZMO
}
