/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.HardSoftScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.WeightedScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.util.Map;

final class HardSoftScoreInliner
extends AbstractScoreInliner<HardSoftScore> {
    int hardScore;
    int softScore;

    HardSoftScoreInliner(Map<Constraint, HardSoftScore> constraintWeightMap, boolean constraintMatchEnabled) {
        super(constraintWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardSoftScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        HardSoftScore constraintWeight = (HardSoftScore)this.constraintWeightMap.get(constraint);
        HardSoftScoreContext context = new HardSoftScoreContext(this, constraint, constraintWeight);
        if (constraintWeight.softScore() == 0) {
            return WeightedScoreImpacter.of(context, HardSoftScoreContext::changeHardScoreBy);
        }
        if (constraintWeight.hardScore() == 0) {
            return WeightedScoreImpacter.of(context, HardSoftScoreContext::changeSoftScoreBy);
        }
        return WeightedScoreImpacter.of(context, HardSoftScoreContext::changeScoreBy);
    }

    @Override
    public HardSoftScore extractScore(int initScore) {
        return HardSoftScore.ofUninitialized((int)initScore, (int)this.hardScore, (int)this.softScore);
    }

    public String toString() {
        return HardSoftScore.class.getSimpleName() + " inliner";
    }
}

