/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.aggregator.swingui;

import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.report.BenchmarkReportConfig;
import ai.timefold.solver.benchmark.impl.aggregator.BenchmarkAggregator;
import ai.timefold.solver.benchmark.impl.aggregator.swingui.CheckBoxTree;
import ai.timefold.solver.benchmark.impl.aggregator.swingui.MixedCheckBox;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReportFactory;
import ai.timefold.solver.benchmark.impl.result.BenchmarkResultIO;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import ai.timefold.solver.swing.impl.SwingUncaughtExceptionHandler;
import ai.timefold.solver.swing.impl.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BenchmarkAggregatorFrame
extends JFrame {
    private final BenchmarkAggregator benchmarkAggregator;
    private final BenchmarkResultIO benchmarkResultIO;
    private final MillisecondsSpentNumberFormat millisecondsSpentNumberFormat;
    private List<PlannerBenchmarkResult> plannerBenchmarkResultList;
    private Map<SingleBenchmarkResult, DefaultMutableTreeNode> resultCheckBoxMapping = new LinkedHashMap<SingleBenchmarkResult, DefaultMutableTreeNode>();
    private Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMapping = new HashMap<SolverBenchmarkResult, String>();
    private CheckBoxTree checkBoxTree;
    private JTextArea detailTextArea;
    private JProgressBar generateProgressBar;
    private JButton generateReportButton;
    private JButton renameNodeButton;
    private boolean exitApplicationWhenReportFinished = true;

    public static void createAndDisplayFromXmlResource(String benchmarkConfigResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource);
        BenchmarkAggregatorFrame.createAndDisplay(benchmarkConfig);
    }

    public static void createAndDisplayFromFreemarkerXmlResource(String templateResource) {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource);
        BenchmarkAggregatorFrame.createAndDisplay(benchmarkConfig);
    }

    public static void createAndDisplay(PlannerBenchmarkConfig benchmarkConfig) {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
        BenchmarkAggregator benchmarkAggregator = new BenchmarkAggregator();
        benchmarkAggregator.setBenchmarkDirectory(benchmarkConfig.getBenchmarkDirectory());
        BenchmarkReportConfig benchmarkReportConfig = benchmarkConfig.getBenchmarkReportConfig();
        benchmarkReportConfig = benchmarkReportConfig != null ? new BenchmarkReportConfig(benchmarkReportConfig) : new BenchmarkReportConfig();
        benchmarkAggregator.setBenchmarkReportConfig(benchmarkReportConfig);
        BenchmarkAggregatorFrame benchmarkAggregatorFrame = new BenchmarkAggregatorFrame(benchmarkAggregator);
        benchmarkAggregatorFrame.init();
        benchmarkAggregatorFrame.setVisible(true);
    }

    public BenchmarkAggregatorFrame(BenchmarkAggregator benchmarkAggregator) {
        super("Benchmark aggregator");
        this.benchmarkAggregator = benchmarkAggregator;
        this.benchmarkResultIO = new BenchmarkResultIO();
        this.plannerBenchmarkResultList = Collections.emptyList();
        Locale locale = benchmarkAggregator.getBenchmarkReportConfig().determineLocale();
        this.millisecondsSpentNumberFormat = new MillisecondsSpentNumberFormat(locale);
    }

    public void init() {
        this.setDefaultCloseOperation(3);
        this.initPlannerBenchmarkResultList();
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JComponent createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.createTopButtonPanel(), "North");
        contentPane.add((Component)this.createBenchmarkTreePanel(), "Center");
        contentPane.add((Component)this.createDetailTextArea(), "South");
        return contentPane;
    }

    private JComponent createNoPlannerFoundTextField() {
        String infoMessage = "No planner benchmarks have been found in the benchmarkDirectory (" + String.valueOf(this.benchmarkAggregator.getBenchmarkDirectory()) + ").";
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(infoMessage);
        StyledDocument styledDocument = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        StyleConstants.setBold(center, true);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), center, false);
        return textPane;
    }

    private JComponent createDetailTextArea() {
        JPanel detailPanel = new JPanel(new BorderLayout());
        JLabel detailLabel = new JLabel("Details");
        detailPanel.add((Component)detailLabel, "North");
        this.detailTextArea = new JTextArea(5, 80);
        this.detailTextArea.setEditable(false);
        JScrollPane detailScrollPane = new JScrollPane(this.detailTextArea, 22, 30);
        detailPanel.add((Component)detailScrollPane, "South");
        return detailPanel;
    }

    private JComponent createTopButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 6));
        buttonPanel.add(new JButton(new ExpandNodesAction()));
        buttonPanel.add(new JButton(new CollapseNodesAction()));
        buttonPanel.add(new JButton(new MoveNodeAction(true)));
        buttonPanel.add(new JButton(new MoveNodeAction(false)));
        this.renameNodeButton = new JButton(new RenameNodeAction());
        this.renameNodeButton.setEnabled(false);
        buttonPanel.add(this.renameNodeButton);
        buttonPanel.add(new JButton(new SwitchLevelsAction(false)));
        return buttonPanel;
    }

    private JComponent createBenchmarkTreePanel() {
        JPanel benchmarkTreePanel = new JPanel(new BorderLayout());
        benchmarkTreePanel.add((Component)new JScrollPane(this.plannerBenchmarkResultList.isEmpty() ? this.createNoPlannerFoundTextField() : this.createCheckBoxTree(), 22, 30), "Center");
        JPanel buttonPanelWrapper = new JPanel(new FlowLayout(2));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.generateReportButton = new JButton(new GenerateReportAction(this));
        this.generateReportButton.setEnabled(false);
        buttonPanel.add(this.generateReportButton);
        this.generateProgressBar = new JProgressBar();
        buttonPanel.add(this.generateProgressBar);
        buttonPanelWrapper.add(buttonPanel);
        benchmarkTreePanel.add((Component)buttonPanelWrapper, "South");
        benchmarkTreePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        return benchmarkTreePanel;
    }

    private CheckBoxTree createCheckBoxTree() {
        final CheckBoxTree resultCheckBoxTree = new CheckBoxTree(this.initBenchmarkHierarchy(true));
        resultCheckBoxTree.addTreeSelectionListener(e -> {
            TreePath treeSelectionPath = e.getNewLeadSelectionPath();
            if (treeSelectionPath != null) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeSelectionPath.getLastPathComponent();
                MixedCheckBox checkBox = (MixedCheckBox)treeNode.getUserObject();
                this.detailTextArea.setText(checkBox.getDetail());
                this.detailTextArea.setCaretPosition(0);
                this.renameNodeButton.setEnabled(checkBox.getBenchmarkResult() instanceof PlannerBenchmarkResult || checkBox.getBenchmarkResult() instanceof SolverBenchmarkResult);
            }
        });
        resultCheckBoxTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BenchmarkAggregatorFrame.this.generateReportButton.setEnabled(!resultCheckBoxTree.getSelectedSingleBenchmarkNodes().isEmpty());
            }
        });
        this.checkBoxTree = resultCheckBoxTree;
        return resultCheckBoxTree;
    }

    private void initPlannerBenchmarkResultList() {
        this.plannerBenchmarkResultList = this.benchmarkResultIO.readPlannerBenchmarkResultList(this.benchmarkAggregator.getBenchmarkDirectory());
        BenchmarkReportFactory reportFactory = new BenchmarkReportFactory(this.benchmarkAggregator.getBenchmarkReportConfig());
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            plannerBenchmarkResult.accumulateResults(reportFactory.buildBenchmarkReport(plannerBenchmarkResult));
        }
    }

    private DefaultMutableTreeNode initBenchmarkHierarchy(boolean solverFirst) {
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(new MixedCheckBox("Planner benchmarks"));
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            DefaultMutableTreeNode plannerNode = new DefaultMutableTreeNode(this.createPlannerBenchmarkCheckBox(plannerBenchmarkResult));
            parentNode.add(plannerNode);
            if (solverFirst) {
                for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                    DefaultMutableTreeNode solverNode = new DefaultMutableTreeNode(this.createSolverBenchmarkCheckBox(solverBenchmarkResult));
                    plannerNode.add(solverNode);
                    for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
                        DefaultMutableTreeNode problemNode = new DefaultMutableTreeNode(this.createProblemBenchmarkCheckBox(problemBenchmarkResult));
                        solverNode.add(problemNode);
                        this.initSingleBenchmarkNodes(solverBenchmarkResult, problemBenchmarkResult, problemNode);
                    }
                }
                continue;
            }
            for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
                DefaultMutableTreeNode problemNode = new DefaultMutableTreeNode(this.createProblemBenchmarkCheckBox(problemBenchmarkResult));
                plannerNode.add(problemNode);
                for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                    DefaultMutableTreeNode solverNode = new DefaultMutableTreeNode(this.createSolverBenchmarkCheckBox(solverBenchmarkResult));
                    problemNode.add(solverNode);
                    this.initSingleBenchmarkNodes(solverBenchmarkResult, problemBenchmarkResult, solverNode);
                }
            }
        }
        return parentNode;
    }

    private void initSingleBenchmarkNodes(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, DefaultMutableTreeNode problemNode) {
        for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
            if (!singleBenchmarkResult.getProblemBenchmarkResult().equals(problemBenchmarkResult)) continue;
            DefaultMutableTreeNode singleBenchmarkNode = this.resultCheckBoxMapping.get(singleBenchmarkResult);
            if (singleBenchmarkNode != null) {
                problemNode.add(singleBenchmarkNode);
                continue;
            }
            DefaultMutableTreeNode singleNode = new DefaultMutableTreeNode(this.createSingleBenchmarkCheckBox(singleBenchmarkResult));
            problemNode.add(singleNode);
            this.resultCheckBoxMapping.put(singleBenchmarkResult, singleNode);
        }
    }

    private MixedCheckBox createPlannerBenchmarkCheckBox(PlannerBenchmarkResult plannerBenchmarkResult) {
        String plannerBenchmarkDetail = String.format("Average score: %s%nAverage problem scale: %d", plannerBenchmarkResult.getAverageScore(), plannerBenchmarkResult.getAverageProblemScale());
        return new MixedCheckBox(plannerBenchmarkResult.getName(), plannerBenchmarkDetail, plannerBenchmarkResult);
    }

    private MixedCheckBox createSolverBenchmarkCheckBox(SolverBenchmarkResult solverBenchmarkResult) {
        String solverCheckBoxName = solverBenchmarkResult.getName() + " (" + solverBenchmarkResult.getRanking() + ")";
        String solverBenchmarkDetail = String.format("Total score: %s%nAverage score: %s%nTotal winning score difference: %sAverage time spent: %s%n", solverBenchmarkResult.getTotalScore(), solverBenchmarkResult.getAverageScore(), solverBenchmarkResult.getTotalWinningScoreDifference(), solverBenchmarkResult.getAverageTimeMillisSpent() == null ? "" : this.millisecondsSpentNumberFormat.format(solverBenchmarkResult.getAverageTimeMillisSpent()));
        this.solverBenchmarkResultNameMapping.put(solverBenchmarkResult, solverBenchmarkResult.getName());
        return new MixedCheckBox(solverCheckBoxName, solverBenchmarkDetail, solverBenchmarkResult);
    }

    private MixedCheckBox createProblemBenchmarkCheckBox(ProblemBenchmarkResult problemBenchmarkResult) {
        String problemBenchmarkDetail = String.format("Entity count: %d%nProblem scale: %d%nUsed memory: %s", problemBenchmarkResult.getEntityCount(), problemBenchmarkResult.getProblemScale(), this.toEmptyStringIfNull(problemBenchmarkResult.getAverageUsedMemoryAfterInputSolution()));
        return new MixedCheckBox(problemBenchmarkResult.getName(), problemBenchmarkDetail);
    }

    private MixedCheckBox createSingleBenchmarkCheckBox(SingleBenchmarkResult singleBenchmarkResult) {
        String singleCheckBoxName = singleBenchmarkResult.getName() + " (" + singleBenchmarkResult.getRanking() + ")";
        String singleBenchmarkDetail = String.format("Score: %s%nUsed memory: %s%nTime spent: %s", singleBenchmarkResult.getAverageScore(), this.toEmptyStringIfNull(singleBenchmarkResult.getUsedMemoryAfterInputSolution()), this.millisecondsSpentNumberFormat.format(singleBenchmarkResult.getTimeMillisSpent()));
        return new MixedCheckBox(singleCheckBoxName, singleBenchmarkDetail, singleBenchmarkResult);
    }

    private String toEmptyStringIfNull(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private void refresh() {
        this.initPlannerBenchmarkResultList();
        this.solverBenchmarkResultNameMapping = new HashMap<SolverBenchmarkResult, String>();
        this.resultCheckBoxMapping = new LinkedHashMap<SingleBenchmarkResult, DefaultMutableTreeNode>();
        this.checkBoxTree.setSelectedSingleBenchmarkNodes(new HashSet<DefaultMutableTreeNode>());
        DefaultMutableTreeNode newCheckBoxRootNode = this.initBenchmarkHierarchy(true);
        DefaultTreeModel treeModel = new DefaultTreeModel(newCheckBoxRootNode);
        this.checkBoxTree.setModel(treeModel);
        treeModel.nodeStructureChanged(newCheckBoxRootNode);
        this.setEnabled(true);
    }

    private class ExpandNodesAction
    extends AbstractAction {
        public ExpandNodesAction() {
            super("Expand", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("expand.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.expandNodes();
        }
    }

    private class CollapseNodesAction
    extends AbstractAction {
        public CollapseNodesAction() {
            super("Collapse", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("collapse.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.collapseNodes();
        }
    }

    private class MoveNodeAction
    extends AbstractAction {
        private boolean directionUp;

        public MoveNodeAction(boolean directionUp) {
            super(directionUp ? "Move up" : "Move down", new ImageIcon(BenchmarkAggregatorFrame.class.getResource(directionUp ? "moveUp.png" : "moveDown.png")));
            this.directionUp = directionUp;
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            DefaultMutableTreeNode parentNode;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && (parentNode = (DefaultMutableTreeNode)(selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()).getParent()) != null) {
                DefaultMutableTreeNode immediateSiblingNode;
                DefaultMutableTreeNode defaultMutableTreeNode = immediateSiblingNode = this.directionUp ? (DefaultMutableTreeNode)parentNode.getChildBefore(selectedNode) : (DefaultMutableTreeNode)parentNode.getChildAfter(selectedNode);
                if (immediateSiblingNode != null) {
                    parentNode.insert(immediateSiblingNode, parentNode.getIndex(selectedNode));
                    ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeStructureChanged(parentNode);
                    BenchmarkAggregatorFrame.this.checkBoxTree.setSelectionPath(new TreePath(selectedNode.getPath()));
                }
            }
        }
    }

    private class RenameNodeAction
    extends AbstractAction {
        public RenameNodeAction() {
            super("Rename", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("rename.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            MixedCheckBox mixedCheckBox;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && ((mixedCheckBox = (MixedCheckBox)(selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()).getUserObject()).getBenchmarkResult() instanceof PlannerBenchmarkResult || mixedCheckBox.getBenchmarkResult() instanceof SolverBenchmarkResult)) {
                RenameNodeDialog renameNodeDialog = new RenameNodeDialog(selectedNode);
                renameNodeDialog.pack();
                renameNodeDialog.setLocationRelativeTo(BenchmarkAggregatorFrame.this);
                renameNodeDialog.setVisible(true);
            }
        }
    }

    private class SwitchLevelsAction
    extends AbstractAction {
        private boolean solverLevelFirst;

        public SwitchLevelsAction(boolean solverLevelFirst) {
            super("Switch levels", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("switchTree.png")));
            this.solverLevelFirst = solverLevelFirst;
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode treeRoot = BenchmarkAggregatorFrame.this.initBenchmarkHierarchy(this.solverLevelFirst);
            DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
            BenchmarkAggregatorFrame.this.checkBoxTree.setModel(treeModel);
            treeModel.nodeStructureChanged(treeRoot);
            this.solverLevelFirst = !this.solverLevelFirst;
            BenchmarkAggregatorFrame.this.checkBoxTree.setSelectedSingleBenchmarkNodes(new HashSet<DefaultMutableTreeNode>());
            for (Map.Entry<SingleBenchmarkResult, DefaultMutableTreeNode> entry : BenchmarkAggregatorFrame.this.resultCheckBoxMapping.entrySet()) {
                if (((MixedCheckBox)entry.getValue().getUserObject()).getStatus() != MixedCheckBox.MixedCheckBoxStatus.CHECKED) continue;
                BenchmarkAggregatorFrame.this.checkBoxTree.getSelectedSingleBenchmarkNodes().add(entry.getValue());
            }
            BenchmarkAggregatorFrame.this.checkBoxTree.updateHierarchyCheckBoxStates();
        }
    }

    private class GenerateReportAction
    extends AbstractAction {
        private final BenchmarkAggregatorFrame parentFrame;

        public GenerateReportAction(BenchmarkAggregatorFrame parentFrame) {
            super("Generate report");
            this.parentFrame = parentFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parentFrame.setEnabled(false);
            this.generateReport();
        }

        private void generateReport() {
            ArrayList<SingleBenchmarkResult> singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
            for (Map.Entry<SingleBenchmarkResult, DefaultMutableTreeNode> entry : BenchmarkAggregatorFrame.this.resultCheckBoxMapping.entrySet()) {
                if (((MixedCheckBox)entry.getValue().getUserObject()).getStatus() != MixedCheckBox.MixedCheckBoxStatus.CHECKED) continue;
                singleBenchmarkResultList.add(entry.getKey());
            }
            if (singleBenchmarkResultList.isEmpty()) {
                JOptionPane.showMessageDialog(this.parentFrame, "No single benchmarks have been selected.", "Warning", 2);
                this.parentFrame.setEnabled(true);
            } else {
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString("Generating...");
                GenerateReportWorker worker = new GenerateReportWorker(this.parentFrame, singleBenchmarkResultList);
                worker.execute();
            }
        }
    }

    private class ReportFinishedDialog
    extends JDialog {
        private final BenchmarkAggregatorFrame parentFrame;
        private final File reportFile;
        private JCheckBox exitCheckBox;

        public ReportFinishedDialog(BenchmarkAggregatorFrame parentFrame, File reportFile) {
            super((Frame)parentFrame, "Report generation finished");
            this.parentFrame = parentFrame;
            this.reportFile = reportFile;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BenchmarkAggregatorFrame.this.refresh();
                }
            });
            JPanel mainPanel = new JPanel(new BorderLayout(0, 10));
            this.exitCheckBox = new JCheckBox("Exit application", BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished);
            mainPanel.add((Component)this.exitCheckBox, "North");
            mainPanel.add((Component)this.createButtonPanel(), "Center");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(mainPanel);
        }

        private JPanel createButtonPanel() {
            final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            AbstractAction openBrowserAction = new AbstractAction("Show in browser"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        desktop.browse(ReportFinishedDialog.this.reportFile.getAbsoluteFile().toURI());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed showing reportFile (" + String.valueOf(ReportFinishedDialog.this.reportFile) + ") in the default browser.", e);
                    }
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            openBrowserAction.setEnabled(desktop != null && desktop.isSupported(Desktop.Action.BROWSE));
            buttonPanel.add(new JButton(openBrowserAction));
            AbstractAction openFileAction = new AbstractAction("Show in files"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        desktop.open(ReportFinishedDialog.this.reportFile.getParentFile());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed showing reportFile (" + String.valueOf(ReportFinishedDialog.this.reportFile) + ") in the file explorer.", e);
                    }
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            openFileAction.setEnabled(desktop != null && desktop.isSupported(Desktop.Action.OPEN));
            buttonPanel.add(new JButton(openFileAction));
            AbstractAction closeAction = new AbstractAction("Ok"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            buttonPanel.add(new JButton(closeAction));
            return buttonPanel;
        }

        private void finishDialog() {
            BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished = this.exitCheckBox.isSelected();
            if (BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished) {
                this.parentFrame.dispose();
            } else {
                this.dispose();
                this.parentFrame.refresh();
            }
        }
    }

    private class GenerateReportWorker
    extends SwingWorker<File, Void> {
        private final BenchmarkAggregatorFrame parentFrame;
        private List<SingleBenchmarkResult> singleBenchmarkResultList;

        public GenerateReportWorker(BenchmarkAggregatorFrame parentFrame, List<SingleBenchmarkResult> singleBenchmarkResultList) {
            this.parentFrame = parentFrame;
            this.singleBenchmarkResultList = singleBenchmarkResultList;
        }

        @Override
        protected File doInBackground() {
            return BenchmarkAggregatorFrame.this.benchmarkAggregator.aggregateSelectedBenchmarksInUi(this.singleBenchmarkResultList, BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping);
        }

        @Override
        protected void done() {
            try {
                File htmlOverviewFile = (File)this.get();
                ReportFinishedDialog dialog = new ReportFinishedDialog(this.parentFrame, htmlOverviewFile);
                dialog.pack();
                dialog.setLocationRelativeTo(this.parentFrame);
                dialog.setVisible(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("The report generation was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("The report generation failed.", e.getCause());
            }
            finally {
                BenchmarkAggregatorFrame.this.detailTextArea.setText(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(false);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(false);
            }
        }
    }

    private class RenameNodeDialog
    extends JDialog {
        public RenameNodeDialog(final DefaultMutableTreeNode treeNode) {
            super((Frame)BenchmarkAggregatorFrame.this, "Rename node");
            final MixedCheckBox mixedCheckBox = (MixedCheckBox)treeNode.getUserObject();
            final Object benchmarkResult = mixedCheckBox.getBenchmarkResult();
            JPanel mainPanel = new JPanel(new BorderLayout());
            String benchmarkResultTextFieldText = null;
            if (benchmarkResult instanceof SolverBenchmarkResult) {
                benchmarkResultTextFieldText = BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping.get(benchmarkResult);
            }
            final JTextField benchmarkResultNameTextField = new JTextField(benchmarkResultTextFieldText == null ? benchmarkResult.toString() : benchmarkResultTextFieldText, 30);
            mainPanel.add((Component)benchmarkResultNameTextField, "West");
            AbstractAction renamedAction = new AbstractAction("Rename"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newBenchmarkResultName = benchmarkResultNameTextField.getText();
                    if (newBenchmarkResultName == null || newBenchmarkResultName.isEmpty()) {
                        JOptionPane.showMessageDialog(BenchmarkAggregatorFrame.this, "New benchmark's name cannot be empty.", "Warning", 2);
                    } else {
                        if (benchmarkResult instanceof PlannerBenchmarkResult) {
                            PlannerBenchmarkResult result = (PlannerBenchmarkResult)benchmarkResult;
                            result.setName(newBenchmarkResultName);
                            mixedCheckBox.setText(newBenchmarkResultName);
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                        } else if (benchmarkResult instanceof SolverBenchmarkResult) {
                            SolverBenchmarkResult result = (SolverBenchmarkResult)benchmarkResult;
                            mixedCheckBox.setText(newBenchmarkResultName + " (" + result.getRanking() + ")");
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                            BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping.put(result, newBenchmarkResultName);
                        }
                        RenameNodeDialog.this.dispose();
                    }
                }
            };
            benchmarkResultNameTextField.addActionListener(renamedAction);
            JButton confirmRenameButton = new JButton(renamedAction);
            mainPanel.add((Component)confirmRenameButton, "East");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(mainPanel);
        }
    }
}

