/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.report;

import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.Chart;
import ai.timefold.solver.benchmark.impl.report.Dataset;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public record BarChart<Y extends Number>(String id, String title, String xLabel, String yLabel, List<String> categories, List<Dataset<Y>> datasets, boolean timeOnY) implements Chart
{
    public BarChart(String id, String title, String xLabel, String yLabel, List<String> categories, List<Dataset<Y>> datasets, boolean timeOnY) {
        this.id = id = Chart.makeIdUnique(id);
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.categories = categories;
        this.datasets = datasets;
        this.timeOnY = timeOnY;
    }

    public BigDecimal yMin() {
        return LineChart.min(this.getYValues());
    }

    private List<Y> getYValues() {
        return this.datasets.stream().flatMap(d -> d.data().stream()).filter(x$0 -> Objects.nonNull(x$0)).toList();
    }

    public BigDecimal yMax() {
        return LineChart.max(this.getYValues());
    }

    public BigDecimal yStepSize() {
        return LineChart.stepSize(this.yMin(), this.yMax());
    }

    public boolean yLogarithmic() {
        if (this.timeOnY) {
            return false;
        }
        return LineChart.useLogarithmicProblemScale(this.getYValues());
    }

    @Override
    public void writeToFile(Path parentFolder) {
        File file = new File(parentFolder.toFile(), this.id() + ".js");
        file.getParentFile().mkdirs();
        Configuration freeMarkerCfg = BenchmarkReport.createFreeMarkerConfiguration();
        freeMarkerCfg.setClassForTemplateLoading(this.getClass(), "");
        String templateFilename = "chart-bar.js.ftl";
        HashMap<String, BarChart> model = new HashMap<String, BarChart>();
        model.put("chart", this);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Template template = freeMarkerCfg.getTemplate(templateFilename);
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write chart file (" + String.valueOf(file) + ").", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to chart file (" + this.id + ").", e);
        }
    }

    public static final class Builder<Y extends Number> {
        private final Map<String, NavigableMap<String, Y>> data = new LinkedHashMap<String, NavigableMap<String, Y>>();
        private final Set<String> favoriteSet = new HashSet<String>();

        public Builder<Y> add(String dataset, String category, Y y) {
            this.data.computeIfAbsent(dataset, k -> new TreeMap()).put(category, y);
            return this;
        }

        public Set<String> keys() {
            return this.data.keySet();
        }

        public Builder<Y> markFavorite(String dataset) {
            this.favoriteSet.add(dataset);
            return this;
        }

        public BarChart<Y> build(String fileName, String title, String xLabel, String yLabel, boolean timeOnY) {
            List<String> categories = this.data.values().stream().flatMap(m -> m.keySet().stream()).distinct().sorted(Comparable::compareTo).toList();
            ArrayList datasetList = new ArrayList(this.data.size());
            for (String datasetLabel : this.data.keySet()) {
                ArrayList<Number> datasetData = new ArrayList<Number>(categories.size());
                for (String category : categories) {
                    Number yValue = (Number)this.data.get(datasetLabel).get(category);
                    datasetData.add(yValue);
                }
                datasetList.add(new Dataset(datasetLabel, datasetData, this.favoriteSet.contains(datasetLabel)));
            }
            return new BarChart(fileName, title, xLabel, yLabel, categories, datasetList, timeOnY);
        }
    }
}

