/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore;

import ai.timefold.solver.benchmark.config.statistic.SingleStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.PureSubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.StatisticRegistry;
import ai.timefold.solver.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore.ConstraintMatchTotalBestScoreStatisticPoint;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;

public class ConstraintMatchTotalBestScoreSubSingleStatistic<Solution_>
extends PureSubSingleStatistic<Solution_, ConstraintMatchTotalBestScoreStatisticPoint, LineChart<Long, Double>> {
    private ConstraintMatchTotalBestScoreSubSingleStatistic() {
    }

    public ConstraintMatchTotalBestScoreSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, SingleStatisticType.CONSTRAINT_MATCH_TOTAL_BEST_SCORE);
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag) {
        registry.addListener(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE, timeMillisSpent -> registry.extractConstraintSummariesFromMeters(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE, runTag, constraintSummary -> this.pointList.add(new ConstraintMatchTotalBestScoreStatisticPoint((long)timeMillisSpent, constraintSummary.constraintRef(), constraintSummary.count(), (Score)constraintSummary.score()))));
    }

    @Override
    protected String getCsvHeader() {
        return ConstraintMatchTotalBestScoreStatisticPoint.buildCsvLine("timeMillisSpent", "constraintPackage", "constraintName", "constraintMatchCount", "scoreTotal");
    }

    @Override
    protected ConstraintMatchTotalBestScoreStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new ConstraintMatchTotalBestScoreStatisticPoint(Long.parseLong(csvLine.get(0)), ConstraintRef.of((String)csvLine.get(1), (String)csvLine.get(2)), Integer.parseInt(csvLine.get(3)), scoreDefinition.parseScore(csvLine.get(4)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<LineChart<Long, Double>> generateCharts(BenchmarkReport benchmarkReport) {
        void var6_18;
        Object levelValues;
        ArrayList builderList = new ArrayList(15);
        for (ConstraintMatchTotalBestScoreStatisticPoint point : this.getPointList()) {
            long timeMillisSpent = point.getTimeMillisSpent();
            levelValues = point.getScoreTotal().toLevelDoubles();
            for (int i = 0; i < ((double[])levelValues).length && i < 15; ++i) {
                String seriesLabel;
                LineChart.Builder builder;
                double lastValue;
                if (i >= builderList.size()) {
                    builderList.add(new LineChart.Builder());
                }
                double d = lastValue = (builder = (LineChart.Builder)builderList.get(i)).count(seriesLabel = point.getConstraintRef().constraintName() + " weight") == 0 ? 0.0 : (Double)builder.getLastValue(seriesLabel);
                if (levelValues[i] == lastValue) continue;
                builder.add(seriesLabel, timeMillisSpent, (double)levelValues[i]);
            }
        }
        long timeMillisSpent = this.subSingleBenchmarkResult.getTimeMillisSpent();
        for (LineChart.Builder builder : builderList) {
            levelValues = builder.keys().iterator();
            while (levelValues.hasNext()) {
                String key = (String)levelValues.next();
                builder.add(key, timeMillisSpent, (Double)builder.getLastValue(key));
            }
        }
        ArrayList<LineChart<Long, Double>> chartList = new ArrayList<LineChart<Long, Double>>(builderList.size());
        boolean bl = false;
        while (var6_18 < builderList.size()) {
            String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel((int)var6_18);
            LineChart.Builder builder = (LineChart.Builder)builderList.get((int)var6_18);
            LineChart chart = builder.build("constraintMatchTotalBestScoreSubSingleStatisticChart" + (int)var6_18, this.subSingleBenchmarkResult.getName() + " constraint match total best " + scoreLevelLabel + " diff statistic", "Time spent", "Constraint match total " + scoreLevelLabel, true, true, false);
            chartList.add(chart);
            ++var6_18;
        }
        return chartList;
    }
}

