/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.report;

import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.Chart;
import ai.timefold.solver.benchmark.impl.report.Range;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public record BoxPlot(String id, String title, String xLabel, String yLabel, List<String> categories, Map<String, List<Range>> ranges, Set<String> favorites) implements Chart
{
    public BoxPlot(String id, String title, String xLabel, String yLabel, List<String> categories, Map<String, List<Range>> ranges, Set<String> favorites) {
        this.id = id = Chart.makeIdUnique(id);
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.categories = categories;
        this.ranges = ranges;
        this.favorites = favorites;
    }

    @Override
    public void writeToFile(Path parentFolder) {
        File file = new File(parentFolder.toFile(), this.id() + ".js");
        file.getParentFile().mkdirs();
        Configuration freeMarkerCfg = BenchmarkReport.createFreeMarkerConfiguration();
        freeMarkerCfg.setClassForTemplateLoading(this.getClass(), "");
        String templateFilename = "chart-box.js.ftl";
        HashMap<String, BoxPlot> model = new HashMap<String, BoxPlot>();
        model.put("chart", this);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Template template = freeMarkerCfg.getTemplate(templateFilename);
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write chart file (" + String.valueOf(file) + ").", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to chart file (" + this.id + ").", e);
        }
    }

    public static final class Builder {
        private final Map<String, NavigableMap<String, List<Double>>> data = new LinkedHashMap<String, NavigableMap<String, List<Double>>>();
        private final Set<String> favoriteSet = new HashSet<String>();

        public Builder add(String dataset, String category, double y) {
            this.data.computeIfAbsent(dataset, k -> new TreeMap()).computeIfAbsent(category, k -> new ArrayList()).add(y);
            return this;
        }

        public Set<String> keys() {
            return this.data.keySet();
        }

        public Builder markFavorite(String dataset) {
            this.favoriteSet.add(dataset);
            return this;
        }

        public BoxPlot build(String fileName, String title, String xLabel, String yLabel) {
            List<String> categories = this.data.values().stream().flatMap(m -> m.keySet().stream()).distinct().sorted(Comparable::compareTo).toList();
            LinkedHashMap<String, List<Range>> rangeMap = new LinkedHashMap<String, List<Range>>(this.data.size());
            for (String rangeLabel : this.data.keySet()) {
                ArrayList<Range> rangeList = new ArrayList<Range>();
                for (String category : categories) {
                    List<Double> values = this.data.get(rangeLabel).getOrDefault(category, Collections.emptyList());
                    if (values.size() == 0) {
                        rangeList.add(null);
                        continue;
                    }
                    DescriptiveStatistics stats = new DescriptiveStatistics();
                    values.forEach(arg_0 -> ((DescriptiveStatistics)stats).addValue(arg_0));
                    rangeList.add(new Range(rangeLabel, stats.getMin(), stats.getPercentile(25.0), stats.getPercentile(50.0), stats.getPercentile(75.0), stats.getMax(), stats.getMean()));
                }
                rangeMap.put(rangeLabel, rangeList);
            }
            return new BoxPlot(fileName, title, xLabel, yLabel, categories, rangeMap, this.favoriteSet);
        }
    }
}

