/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl;

import ai.timefold.solver.benchmark.api.PlannerBenchmark;
import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import ai.timefold.solver.benchmark.config.report.BenchmarkReportConfig;
import ai.timefold.solver.benchmark.impl.DefaultPlannerBenchmark;
import ai.timefold.solver.benchmark.impl.SolverBenchmarkFactory;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReportFactory;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.solver.thread.DefaultSolverThreadFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlannerBenchmarkFactory
extends PlannerBenchmarkFactory {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("(?U)^[\\w\\d _\\-\\.\\(\\)]+$");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlannerBenchmarkFactory.class);
    protected final PlannerBenchmarkConfig plannerBenchmarkConfig;

    public DefaultPlannerBenchmarkFactory(PlannerBenchmarkConfig plannerBenchmarkConfig) {
        if (plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + String.valueOf(plannerBenchmarkConfig) + ") cannot be null.");
        }
        this.plannerBenchmarkConfig = plannerBenchmarkConfig;
    }

    @Override
    public @NonNull PlannerBenchmark buildPlannerBenchmark() {
        return this.buildPlannerBenchmark(new Object[0]);
    }

    @Override
    @SafeVarargs
    public final <Solution_> @NonNull PlannerBenchmark buildPlannerBenchmark(Solution_ ... problems) {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        List<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = this.buildEffectiveSolverBenchmarkConfigList();
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setName(this.plannerBenchmarkConfig.getName());
        plannerBenchmarkResult.setAggregation(false);
        int parallelBenchmarkCount = this.resolveParallelBenchmarkCount();
        plannerBenchmarkResult.setParallelBenchmarkCount(parallelBenchmarkCount);
        plannerBenchmarkResult.setWarmUpTimeMillisSpentLimit(this.calculateWarmUpTimeMillisSpentLimit(30L));
        plannerBenchmarkResult.setUnifiedProblemBenchmarkResultList(new ArrayList<ProblemBenchmarkResult>());
        plannerBenchmarkResult.setSolverBenchmarkResultList(new ArrayList<SolverBenchmarkResult>(effectiveSolverBenchmarkConfigList.size()));
        for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
            SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(solverBenchmarkConfig);
            solverBenchmarkFactory.buildSolverBenchmark(this.plannerBenchmarkConfig.getClassLoader(), plannerBenchmarkResult, problems);
        }
        BenchmarkReportConfig benchmarkReportConfig_ = this.plannerBenchmarkConfig.getBenchmarkReportConfig() == null ? new BenchmarkReportConfig() : this.plannerBenchmarkConfig.getBenchmarkReportConfig();
        BenchmarkReport benchmarkReport = new BenchmarkReportFactory(benchmarkReportConfig_).buildBenchmarkReport(plannerBenchmarkResult);
        return new DefaultPlannerBenchmark(plannerBenchmarkResult, this.plannerBenchmarkConfig.getBenchmarkDirectory(), this.buildExecutorService(parallelBenchmarkCount), this.buildExecutorService(parallelBenchmarkCount), benchmarkReport);
    }

    private ExecutorService buildExecutorService(int parallelBenchmarkCount) {
        return Executors.newFixedThreadPool(parallelBenchmarkCount, this.getThreadFactory());
    }

    private ThreadFactory getThreadFactory() {
        Class<? extends ThreadFactory> threadFactoryClass = this.plannerBenchmarkConfig.getThreadFactoryClass();
        if (threadFactoryClass != null) {
            return (ThreadFactory)ConfigUtils.newInstance((Object)this.plannerBenchmarkConfig, (String)"threadFactoryClass", threadFactoryClass);
        }
        return new DefaultSolverThreadFactory("BenchmarkThread");
    }

    protected void validate() {
        String name = this.plannerBenchmarkConfig.getName();
        if (name != null) {
            if (!VALID_NAME_PATTERN.matcher(name).matches()) {
                throw new IllegalStateException("The plannerBenchmark name (%s) is invalid because it does not follow the nameRegex (%s) which might cause an illegal filename.".formatted(name, VALID_NAME_PATTERN.pattern()));
            }
            if (!name.trim().equals(name)) {
                throw new IllegalStateException("The plannerBenchmark name (%s) is invalid because it starts or ends with whitespace.".formatted(name));
            }
        }
        if (ConfigUtils.isEmptyCollection(this.plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList()) && ConfigUtils.isEmptyCollection(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList())) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> (or 1 <solverBenchmarkBluePrint>) in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        if (this.plannerBenchmarkConfig.getSolverBenchmarkConfigList() != null) {
            HashSet<String> nameSet = new HashSet<String>(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().size());
            LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().size());
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.plannerBenchmarkConfig.getSolverBenchmarkConfigList()) {
                if (solverBenchmarkConfig.getName() != null) {
                    boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                    if (unique) continue;
                    throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
                }
                noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
            }
            int generatedNameIndex = 0;
            for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
                String generatedName = "Config_" + generatedNameIndex;
                while (nameSet.contains(generatedName)) {
                    generatedName = "Config_" + ++generatedNameIndex;
                }
                solverBenchmarkConfig.setName(generatedName);
                ++generatedNameIndex;
            }
        }
    }

    protected List<SolverBenchmarkConfig> buildEffectiveSolverBenchmarkConfigList() {
        SolverBenchmarkConfig inheritedSolverBenchmarkConfig;
        List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList;
        ArrayList<SolverBenchmarkConfig> effectiveSolverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(0);
        List<SolverBenchmarkConfig> solverBenchmarkConfigList = this.plannerBenchmarkConfig.getSolverBenchmarkConfigList();
        if (solverBenchmarkConfigList != null) {
            effectiveSolverBenchmarkConfigList.addAll(solverBenchmarkConfigList);
        }
        if ((solverBenchmarkBluePrintConfigList = this.plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList()) != null) {
            for (SolverBenchmarkBluePrintConfig solverBenchmarkBluePrintConfig : solverBenchmarkBluePrintConfigList) {
                effectiveSolverBenchmarkConfigList.addAll(solverBenchmarkBluePrintConfig.buildSolverBenchmarkConfigList());
            }
        }
        if ((inheritedSolverBenchmarkConfig = this.plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig()) != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : effectiveSolverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(inheritedSolverBenchmarkConfig);
            }
        }
        return effectiveSolverBenchmarkConfigList;
    }

    protected int resolveParallelBenchmarkCount() {
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int resolvedParallelBenchmarkCount = this.actuallyResolverParallelBenchmarkCount(availableProcessorCount);
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (%s) resulted in a resolvedParallelBenchmarkCount (%d) that is lower than 1.".formatted(this.plannerBenchmarkConfig.getParallelBenchmarkCount(), resolvedParallelBenchmarkCount));
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            LOGGER.warn("Because the resolvedParallelBenchmarkCount ({}) is higher than the availableProcessorCount ({}), it is reduced to availableProcessorCount.", (Object)resolvedParallelBenchmarkCount, (Object)availableProcessorCount);
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    private int actuallyResolverParallelBenchmarkCount(int availableProcessorCount) {
        String parallelBenchmarkCount = this.plannerBenchmarkConfig.getParallelBenchmarkCount();
        if (parallelBenchmarkCount == null) {
            return 1;
        }
        if (parallelBenchmarkCount.equals("AUTO")) {
            return this.resolveParallelBenchmarkCountAutomatically(availableProcessorCount);
        }
        return ConfigUtils.resolvePoolSize((String)"parallelBenchmarkCount", (String)parallelBenchmarkCount, (String[])new String[]{"AUTO"});
    }

    protected int resolveParallelBenchmarkCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount <= 2) {
            return 1;
        }
        if (availableProcessorCount <= 4) {
            return 2;
        }
        return availableProcessorCount / 2 + 1;
    }

    protected long calculateWarmUpTimeMillisSpentLimit(long defaultWarmUpTimeMillisSpentLimit) {
        if (this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit() == null && this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit() == null) {
            return defaultWarmUpTimeMillisSpentLimit;
        }
        long warmUpTimeMillisSpentLimit = DefaultPlannerBenchmarkFactory.resolveLimit(this.plannerBenchmarkConfig.getWarmUpMillisecondsSpentLimit(), "warmUpMillisecondsSpentLimit");
        warmUpTimeMillisSpentLimit += DefaultPlannerBenchmarkFactory.resolveLimit(this.plannerBenchmarkConfig.getWarmUpSecondsSpentLimit(), "warmUpSecondsSpentLimit") * 1000L;
        warmUpTimeMillisSpentLimit += DefaultPlannerBenchmarkFactory.resolveLimit(this.plannerBenchmarkConfig.getWarmUpMinutesSpentLimit(), "warmUpMinutesSpentLimit") * 60000L;
        return (warmUpTimeMillisSpentLimit += DefaultPlannerBenchmarkFactory.resolveLimit(this.plannerBenchmarkConfig.getWarmUpHoursSpentLimit(), "warmUpHoursSpentLimit") * 3600000L) + DefaultPlannerBenchmarkFactory.resolveLimit(this.plannerBenchmarkConfig.getWarmUpDaysSpentLimit(), "warmUpDaysSpentLimit") * 86400000L;
    }

    private static long resolveLimit(Long limit, String limitName) {
        if (limit == null) {
            return 0L;
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("The %s (%d) cannot be negative.".formatted(limitName, limit));
        }
        return limit;
    }
}

