/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.util.Map;
import java.util.Objects;

public class PythonSlice
extends AbstractPythonLikeObject {
    public static PythonLikeType SLICE_TYPE;
    public static PythonLikeType $TYPE;
    public final PythonLikeObject start;
    public final PythonLikeObject stop;
    public final PythonLikeObject step;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        SLICE_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            PythonLikeObject step;
            PythonLikeObject stop;
            PythonLikeObject start;
            Map map = namedArguments = namedArguments != null ? namedArguments : Map.of();
            if (positionalArguments.size() == 3) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = (PythonLikeObject)positionalArguments.get(1);
                step = (PythonLikeObject)positionalArguments.get(2);
            } else if (positionalArguments.size() == 2) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = (PythonLikeObject)positionalArguments.get(1);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonNone.INSTANCE);
            } else if (positionalArguments.size() == 1 && namedArguments.containsKey(PythonString.valueOf("stop"))) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = namedArguments.getOrDefault(PythonString.valueOf("stop"), PythonNone.INSTANCE);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonNone.INSTANCE);
            } else if (positionalArguments.size() == 1) {
                stop = (PythonLikeObject)positionalArguments.get(0);
                start = PythonInteger.valueOf(0);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonNone.INSTANCE);
            } else if (positionalArguments.isEmpty()) {
                start = namedArguments.getOrDefault(PythonString.valueOf("start"), (PythonNone)((Object)PythonInteger.valueOf(0)));
                stop = namedArguments.getOrDefault(PythonString.valueOf("stop"), PythonNone.INSTANCE);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonNone.INSTANCE);
            } else {
                throw new ValueError("slice expects 1 to 3 arguments, got " + positionalArguments.size());
            }
            return new PythonSlice(start, stop, step);
        });
        SLICE_TYPE.addUnaryMethod(PythonUnaryOperator.HASH, PythonSlice.class.getMethod("pythonHash", new Class[0]));
        SLICE_TYPE.addBinaryMethod(PythonBinaryOperator.EQUAL, PythonSlice.class.getMethod("pythonEquals", PythonSlice.class));
        SLICE_TYPE.addMethod("indices", PythonSlice.class.getMethod("indices", PythonInteger.class));
        return SLICE_TYPE;
    }

    public PythonSlice(PythonLikeObject start, PythonLikeObject stop, PythonLikeObject step) {
        super(SLICE_TYPE);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.$setAttribute("start", start != null ? start : PythonNone.INSTANCE);
        this.$setAttribute("stop", stop != null ? stop : PythonNone.INSTANCE);
        this.$setAttribute("step", step != null ? step : PythonNone.INSTANCE);
    }

    public static int asIntIndexForLength(PythonInteger index, int length) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            return length + indexAsInt;
        }
        return indexAsInt;
    }

    public static int asValidStartIntIndexForLength(PythonInteger index, int length) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            return Math.max(0, Math.min(length - 1, length + indexAsInt));
        }
        return Math.max(0, Math.min(length - 1, indexAsInt));
    }

    public static int asValidEndIntIndexForLength(PythonInteger index, int length) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            return Math.max(0, Math.min(length, length + indexAsInt));
        }
        return Math.max(0, Math.min(length, indexAsInt));
    }

    private SliceIndices getSliceIndices(int length) {
        return new SliceIndices(this.getStartIndex(length), this.getStopIndex(length), this.getStrideLength());
    }

    private SliceIndices getSliceIndices(PythonInteger length) {
        return this.getSliceIndices(length.getValue().intValue());
    }

    public PythonLikeTuple indices(PythonInteger sequenceLength) {
        SliceIndices sliceIndices = this.getSliceIndices(sequenceLength);
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonInteger[]{PythonInteger.valueOf(sliceIndices.start), PythonInteger.valueOf(sliceIndices.start), PythonInteger.valueOf(sliceIndices.strideLength)});
    }

    public int getStartIndex(int length) {
        boolean isReversed;
        boolean bl = isReversed = this.getStrideLength() < 0;
        int startIndex = this.start instanceof PythonInteger ? ((PythonInteger)this.start).value.intValueExact() : (this.start == PythonNone.INSTANCE ? (isReversed ? length - 1 : 0) : ((PythonInteger)UnaryDunderBuiltin.INDEX.invoke((PythonLikeObject)this.start)).value.intValueExact());
        if (startIndex < 0) {
            startIndex = length + startIndex;
        }
        if (!isReversed && startIndex > length) {
            startIndex = length;
        } else if (isReversed && startIndex > length - 1) {
            startIndex = length - 1;
        }
        return startIndex;
    }

    public int getStopIndex(int length) {
        boolean isReversed;
        boolean bl = isReversed = this.getStrideLength() < 0;
        int stopIndex = this.stop instanceof PythonInteger ? ((PythonInteger)this.stop).value.intValueExact() : (this.stop == PythonNone.INSTANCE ? (isReversed ? -length - 1 : length) : ((PythonInteger)UnaryDunderBuiltin.INDEX.invoke((PythonLikeObject)this.stop)).value.intValueExact());
        if (stopIndex < 0) {
            stopIndex = length + stopIndex;
        }
        if (!isReversed && stopIndex > length) {
            stopIndex = length;
        } else if (isReversed && stopIndex > length - 1) {
            stopIndex = length - 1;
        }
        return stopIndex;
    }

    public int getStrideLength() {
        PythonInteger strideLength = this.step instanceof PythonInteger ? (PythonInteger)this.step : (this.step != null && this.step != PythonNone.INSTANCE ? (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(this.step) : PythonInteger.ONE);
        int out = strideLength.value.intValueExact();
        if (out == 0) {
            throw new ValueError("stride length cannot be zero");
        }
        return out;
    }

    public void iterate(int length, SliceConsumer consumer) {
        SliceIndices sliceIndices = this.getSliceIndices(length);
        int step = 0;
        if (sliceIndices.strideLength < 0) {
            for (int i = sliceIndices.start; i > sliceIndices.stop; i += sliceIndices.strideLength) {
                consumer.accept(i, step);
                ++step;
            }
        } else {
            for (int i = sliceIndices.start; i < sliceIndices.stop; i += sliceIndices.strideLength) {
                consumer.accept(i, step);
                ++step;
            }
        }
    }

    private boolean isReversed() {
        return this.getStrideLength() < 0;
    }

    public int getSliceSize(int length) {
        SliceIndices sliceIndices = this.getSliceIndices(length);
        int span = sliceIndices.stop - sliceIndices.start;
        int strideLength = sliceIndices.strideLength;
        return span / strideLength + (span % strideLength == 0 ? 0 : 1);
    }

    public PythonBoolean pythonEquals(PythonSlice other) {
        return PythonBoolean.valueOf(this.equals(other));
    }

    public PythonInteger pythonHash() {
        return PythonInteger.valueOf(this.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonSlice that = (PythonSlice)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.stop, that.stop) && Objects.equals(this.step, that.step);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.stop, this.step);
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    static {
        $TYPE = SLICE_TYPE = new PythonLikeType("slice", PythonSlice.class);
        PythonOverloadImplementor.deferDispatchesFor(PythonSlice::registerMethods);
    }

    private record SliceIndices(int start, int stop, int strideLength) {
    }

    public static interface SliceConsumer {
        public void accept(int var1, int var2);
    }
}

