/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.ExceptionBlock;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.util.JumpUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PythonExceptionTable {
    private final List<ExceptionBlock> blockList = new ArrayList<ExceptionBlock>();

    public void addEntry(PythonVersion pythonVersion, int blockStartInstructionInclusive, int blockEndInstructionInclusive, int targetByteOffset, int stackDepth, boolean pushLastIndex) {
        this.blockList.add(new ExceptionBlock(JumpUtils.getInstructionIndexForByteOffset(blockStartInstructionInclusive, pythonVersion), JumpUtils.getInstructionIndexForByteOffset(blockEndInstructionInclusive, pythonVersion) + 1, JumpUtils.getInstructionIndexForByteOffset(targetByteOffset, pythonVersion), stackDepth, pushLastIndex));
    }

    public List<ExceptionBlock> getEntries() {
        return this.blockList;
    }

    public boolean containsJumpTarget(int target) {
        return this.blockList.stream().anyMatch(block -> block.targetInstruction == target);
    }

    public Set<Integer> getJumpTargetSet() {
        return this.blockList.stream().map(ExceptionBlock::getTargetInstruction).collect(Collectors.toSet());
    }

    public Set<Integer> getJumpTargetForStartSet(int start) {
        return this.blockList.stream().filter(exceptionBlock -> exceptionBlock.getBlockStartInstructionInclusive() == start).map(ExceptionBlock::getTargetInstruction).collect(Collectors.toSet());
    }

    public List<ExceptionBlock> getInnerExceptionBlockList(int start, Set<Integer> possibleJumpTargetSet) {
        return this.blockList.stream().filter(exceptionBlock -> exceptionBlock.getBlockStartInstructionInclusive() == start || exceptionBlock.containsAnyTargetInSet(possibleJumpTargetSet)).collect(Collectors.toList());
    }

    public Set<Integer> getStartPositionSet() {
        return this.blockList.stream().map(ExceptionBlock::getBlockStartInstructionInclusive).collect(Collectors.toSet());
    }

    public String toString() {
        return this.blockList.stream().map(ExceptionBlock::toString).collect(Collectors.joining("\n    ", "ExceptionTable:\n    ", ""));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonExceptionTable that = (PythonExceptionTable)o;
        return Objects.equals(this.blockList, that.blockList);
    }

    public int hashCode() {
        return Objects.hash(this.blockList);
    }
}

