/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonTernaryOperator;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonBytes;
import ai.timefold.jpyinterpreter.types.PythonBytesLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeDecodeError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.ByteCharSequence;
import ai.timefold.jpyinterpreter.util.StringFormatter;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PythonByteArray
extends AbstractPythonLikeObject
implements PythonBytesLikeObject {
    private static final PythonByteArray ASCII_SPACE = new PythonByteArray(new byte[]{32});
    private static final BitSet ASCII_WHITESPACE_BITSET = PythonByteArray.asBitSet(new PythonByteArray(new byte[]{32, 9, 10, 13, 11, 12}));
    public ByteBuffer valueBuffer;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.BYTE_ARRAY_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.isEmpty()) {
                return new PythonByteArray();
            }
            if (positionalArguments.size() == 1) {
                PythonLikeObject arg = (PythonLikeObject)positionalArguments.get(0);
                if (arg instanceof PythonInteger) {
                    return new PythonByteArray(new byte[((PythonInteger)arg).value.intValueExact()]);
                }
                PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(arg);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] toWrite = new byte[1];
                while (iterator.hasNext()) {
                    PythonLikeObject item = iterator.nextPythonItem();
                    if (!(item instanceof PythonInteger)) {
                        throw new ValueError("bytearray argument 1 must be an int or an iterable of int");
                    }
                    toWrite[0] = ((PythonInteger)item).asByte();
                    out.writeBytes(toWrite);
                }
                return new PythonByteArray(out.toByteArray());
            }
            throw new ValueError("bytearray takes 0 or 1 arguments, not " + positionalArguments.size());
        });
        BuiltinTypes.BYTE_ARRAY_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, PythonByteArray.class.getMethod("repr", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, PythonByteArray.class.getMethod("asString", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonByteArray.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonByteArray.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonByteArray.class.getMethod("getCharAt", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonByteArray.class.getMethod("getSubsequence", PythonSlice.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.DELETE_ITEM, PythonByteArray.class.getMethod("deleteIndex", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.DELETE_ITEM, PythonByteArray.class.getMethod("deleteSlice", PythonSlice.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonByteArray.class.getMethod("containsSubsequence", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonByteArray.class.getMethod("concat", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_ADD, PythonByteArray.class.getMethod("inplaceAdd", PythonLikeObject.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonByteArray.class.getMethod("repeat", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_MULTIPLY, PythonByteArray.class.getMethod("inplaceRepeat", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonByteArray.class.getMethod("interpolate", PythonLikeObject.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonByteArray.class.getMethod("interpolate", PythonLikeTuple.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonByteArray.class.getMethod("interpolate", PythonLikeDict.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addTernaryMethod(PythonTernaryOperator.SET_ITEM, PythonByteArray.class.getMethod("setByte", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addTernaryMethod(PythonTernaryOperator.SET_ITEM, PythonByteArray.class.getMethod("setSlice", PythonSlice.class, PythonLikeObject.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("append", PythonByteArray.class.getMethod("appendByte", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("clear", PythonByteArray.class.getMethod("clear", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("copy", PythonByteArray.class.getMethod("copy", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("extend", PythonByteArray.class.getMethod("extend", PythonLikeObject.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("insert", PythonByteArray.class.getMethod("insert", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("pop", PythonByteArray.class.getMethod("pop", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("pop", PythonByteArray.class.getMethod("pop", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("remove", PythonByteArray.class.getMethod("remove", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("reverse", PythonByteArray.class.getMethod("reverse", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("capitalize", PythonByteArray.class.getMethod("capitalize", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("center", PythonByteArray.class.getMethod("center", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("center", PythonByteArray.class.getMethod("center", PythonInteger.class, PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("count", PythonByteArray.class.getMethod("count", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonLikeTuple.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("endswith", PythonByteArray.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("expandtabs", PythonByteArray.class.getMethod("expandTabs", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("expandtabs", PythonByteArray.class.getMethod("expandTabs", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("find", PythonByteArray.class.getMethod("find", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("index", PythonByteArray.class.getMethod("index", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isalnum", PythonByteArray.class.getMethod("isAlphaNumeric", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isalpha", PythonByteArray.class.getMethod("isAlpha", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isascii", PythonByteArray.class.getMethod("isAscii", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isdigit", PythonByteArray.class.getMethod("isDigit", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("islower", PythonByteArray.class.getMethod("isLower", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isspace", PythonByteArray.class.getMethod("isSpace", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("istitle", PythonByteArray.class.getMethod("isTitle", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("isupper", PythonByteArray.class.getMethod("isUpper", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("join", PythonByteArray.class.getMethod("join", PythonLikeObject.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("ljust", PythonByteArray.class.getMethod("leftJustify", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("ljust", PythonByteArray.class.getMethod("leftJustify", PythonInteger.class, PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("lower", PythonByteArray.class.getMethod("lower", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("lstrip", PythonByteArray.class.getMethod("leftStrip", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("lstrip", PythonByteArray.class.getMethod("leftStrip", PythonNone.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("lstrip", PythonByteArray.class.getMethod("leftStrip", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("partition", PythonByteArray.class.getMethod("partition", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("removeprefix", PythonByteArray.class.getMethod("removePrefix", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("removesuffix", PythonByteArray.class.getMethod("removeSuffix", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("replace", PythonByteArray.class.getMethod("replace", PythonByteArray.class, PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("replace", PythonByteArray.class.getMethod("replace", PythonByteArray.class, PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rfind", PythonByteArray.class.getMethod("rightFind", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rindex", PythonByteArray.class.getMethod("rightIndex", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rjust", PythonByteArray.class.getMethod("rightJustify", PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rjust", PythonByteArray.class.getMethod("rightJustify", PythonInteger.class, PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rpartition", PythonByteArray.class.getMethod("rightPartition", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rsplit", PythonByteArray.class.getMethod("rightSplit", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rsplit", PythonByteArray.class.getMethod("rightSplit", PythonNone.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rsplit", PythonByteArray.class.getMethod("rightSplit", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rsplit", PythonByteArray.class.getMethod("rightSplit", PythonNone.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rsplit", PythonByteArray.class.getMethod("rightSplit", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rstrip", PythonByteArray.class.getMethod("rightStrip", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rstrip", PythonByteArray.class.getMethod("rightStrip", PythonNone.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("rstrip", PythonByteArray.class.getMethod("rightStrip", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("split", PythonByteArray.class.getMethod("split", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("split", PythonByteArray.class.getMethod("split", PythonNone.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("split", PythonByteArray.class.getMethod("split", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("split", PythonByteArray.class.getMethod("split", PythonNone.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("split", PythonByteArray.class.getMethod("split", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("splitlines", PythonByteArray.class.getMethod("splitLines", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("splitlines", PythonByteArray.class.getMethod("splitLines", PythonBoolean.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonLikeTuple.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonByteArray.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonByteArray.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("startswith", PythonByteArray.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("strip", PythonByteArray.class.getMethod("strip", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("strip", PythonByteArray.class.getMethod("strip", PythonNone.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("strip", PythonByteArray.class.getMethod("strip", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("swapcase", PythonByteArray.class.getMethod("swapCase", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("title", PythonByteArray.class.getMethod("title", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("translate", PythonByteArray.class.getMethod("translate", PythonBytes.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("translate", PythonByteArray.class.getMethod("translate", PythonByteArray.class));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("upper", PythonByteArray.class.getMethod("upper", new Class[0]));
        BuiltinTypes.BYTE_ARRAY_TYPE.addMethod("zfill", PythonByteArray.class.getMethod("zfill", PythonInteger.class));
        return BuiltinTypes.BYTE_ARRAY_TYPE;
    }

    public PythonByteArray() {
        super(BuiltinTypes.BYTE_ARRAY_TYPE);
        this.valueBuffer = ByteBuffer.allocate(4096);
        this.valueBuffer.limit(0);
    }

    public PythonByteArray(byte[] data) {
        super(BuiltinTypes.BYTE_ARRAY_TYPE);
        this.valueBuffer = ByteBuffer.allocate(data.length);
        this.valueBuffer.put(data);
        this.valueBuffer.position(0);
    }

    public PythonByteArray(ByteBuffer valueBuffer) {
        super(BuiltinTypes.BYTE_ARRAY_TYPE);
        this.valueBuffer = valueBuffer;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.valueBuffer.duplicate().asReadOnlyBuffer();
    }

    public final ByteCharSequence asCharSequence() {
        return new ByteCharSequence(this.valueBuffer.array(), 0, this.valueBuffer.limit());
    }

    public final PythonString asAsciiString() {
        return PythonString.valueOf(this.asCharSequence().toString());
    }

    public static PythonByteArray fromIntTuple(PythonLikeTuple tuple) {
        byte[] out = new byte[tuple.size()];
        IntStream.range(0, tuple.size()).forEach(index -> {
            out[index] = ((PythonInteger)tuple.get(index)).asByte();
        });
        return new PythonByteArray(out);
    }

    public final PythonLikeTuple asIntTuple() {
        return IntStream.range(0, this.valueBuffer.limit()).mapToObj(index -> PythonBytes.BYTE_TO_INT[Byte.toUnsignedInt(this.valueBuffer.get(index))]).collect(Collectors.toCollection(PythonLikeTuple::new));
    }

    private static BitSet asBitSet(PythonByteArray bytesInBitSet) {
        BitSet out = new BitSet();
        for (int i = 0; i < bytesInBitSet.valueBuffer.limit(); ++i) {
            out.set(bytesInBitSet.valueBuffer.get(i) & 0xFF);
        }
        return out;
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.valueBuffer.limit());
    }

    public PythonInteger getCharAt(PythonInteger position) {
        int index = PythonSlice.asIntIndexForLength(position, this.valueBuffer.limit());
        if (index >= this.valueBuffer.limit()) {
            throw new IndexError("position " + String.valueOf(position) + " larger than bytes length " + this.valueBuffer.limit());
        }
        if (index < 0) {
            throw new IndexError("position " + String.valueOf(position) + " is less than 0");
        }
        return PythonBytes.BYTE_TO_INT[Byte.toUnsignedInt(this.valueBuffer.get(index))];
    }

    public PythonByteArray getSubsequence(PythonSlice slice) {
        int length = this.valueBuffer.limit();
        int start = slice.getStartIndex(length);
        int stop = slice.getStopIndex(length);
        int step = slice.getStrideLength();
        if (step == 1) {
            if (stop <= start) {
                return new PythonByteArray(new byte[0]);
            }
            return new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), start, stop));
        }
        byte[] out = new byte[slice.getSliceSize(length)];
        slice.iterate(length, (index, iteration) -> {
            out[iteration] = this.valueBuffer.get(index);
        });
        return new PythonByteArray(out);
    }

    public PythonBoolean containsSubsequence(PythonByteArray subsequence) {
        if (subsequence.valueBuffer.limit() == 0) {
            return PythonBoolean.TRUE;
        }
        if (subsequence.valueBuffer.limit() > this.valueBuffer.limit()) {
            return PythonBoolean.FALSE;
        }
        for (int i = 0; i <= this.valueBuffer.limit() - subsequence.valueBuffer.limit(); ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + subsequence.valueBuffer.limit(), subsequence.valueBuffer.array(), 0, subsequence.valueBuffer.limit())) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonByteArray concat(PythonByteArray other) {
        if (this.valueBuffer.limit() == 0) {
            return new PythonByteArray(other.valueBuffer.duplicate());
        }
        if (other.valueBuffer.limit() == 0) {
            return new PythonByteArray(this.valueBuffer.duplicate());
        }
        byte[] out = new byte[this.valueBuffer.limit() + other.valueBuffer.limit()];
        System.arraycopy(this.valueBuffer.array(), 0, out, 0, this.valueBuffer.limit());
        System.arraycopy(other.valueBuffer.array(), 0, out, this.valueBuffer.limit(), other.valueBuffer.limit());
        return new PythonByteArray(out);
    }

    public PythonByteArray repeat(PythonInteger times) {
        int timesAsInt = times.value.intValueExact();
        if (timesAsInt <= 0) {
            return new PythonByteArray(new byte[0]);
        }
        byte[] out = new byte[this.valueBuffer.limit() * timesAsInt];
        for (int i = 0; i < timesAsInt; ++i) {
            System.arraycopy(this.valueBuffer.array(), 0, out, i * this.valueBuffer.limit(), this.valueBuffer.limit());
        }
        return new PythonByteArray(out);
    }

    public DelegatePythonIterator<PythonInteger> getIterator() {
        return new DelegatePythonIterator<PythonInteger>(IntStream.range(0, this.valueBuffer.limit()).mapToObj(index -> PythonBytes.BYTE_TO_INT[Byte.toUnsignedInt(this.valueBuffer.get(index))]).iterator());
    }

    public PythonInteger countByte(byte query, int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            if (this.valueBuffer.get(i) != query) continue;
            ++count;
        }
        return PythonInteger.valueOf(count);
    }

    public PythonInteger count(PythonInteger byteAsInt) {
        byte query = byteAsInt.asByte();
        return this.countByte(query, 0, this.valueBuffer.limit());
    }

    public PythonInteger count(PythonInteger byteAsInt, PythonInteger start) {
        byte query = byteAsInt.asByte();
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.countByte(query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger count(PythonInteger byteAsInt, PythonInteger start, PythonInteger end) {
        byte query = byteAsInt.asByte();
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.countByte(query, startAsInt, endAsInt);
    }

    private PythonInteger countSubsequence(byte[] query, int from, int to) {
        int count = 0;
        if (to - from == 0 || query.length > to - from) {
            return PythonInteger.ZERO;
        }
        if (query.length == 0) {
            return PythonInteger.valueOf(to - from + 1);
        }
        for (int i = from; i <= to - query.length; ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + query.length, query, 0, query.length)) continue;
            ++count;
            i += query.length - 1;
        }
        return PythonInteger.valueOf(count);
    }

    public PythonInteger count(PythonByteArray bytes) {
        return this.countSubsequence(bytes.valueBuffer.array(), 0, this.valueBuffer.limit());
    }

    public PythonInteger count(PythonByteArray bytes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.countSubsequence(bytes.valueBuffer.array(), startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger count(PythonByteArray bytes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.countSubsequence(bytes.valueBuffer.array(), startAsInt, endAsInt);
    }

    private static byte[] getBytes(PythonLikeObject iterable) {
        if (iterable instanceof PythonBytes) {
            return ((PythonBytes)iterable).value;
        }
        if (iterable instanceof PythonByteArray) {
            return ((PythonByteArray)iterable).asByteArray();
        }
        PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(iterable);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (iterator.hasNext()) {
            PythonLikeObject next = iterator.nextPythonItem();
            byte[] byteWrapper = new byte[1];
            if (!(next instanceof PythonInteger)) {
                throw new TypeError("'" + next.$getType().getTypeName() + "' object cannot be interpreted as an integer");
            }
            byteWrapper[0] = ((PythonInteger)next).asByte();
            out.writeBytes(byteWrapper);
        }
        return out.toByteArray();
    }

    private void ensureCapacity(int minimumCapacity) {
        int oldCapacity = this.valueBuffer.capacity();
        if (oldCapacity >= minimumCapacity) {
            return;
        }
        int newCapacity = Math.max(oldCapacity + (oldCapacity >> 1), minimumCapacity);
        ByteBuffer newValueBuffer = ByteBuffer.allocate(newCapacity);
        System.arraycopy(this.valueBuffer.array(), 0, newValueBuffer.array(), 0, this.valueBuffer.limit());
        newValueBuffer.limit(this.valueBuffer.limit());
        this.valueBuffer = newValueBuffer;
    }

    private void insertExtraBytesAt(int position, int extraBytes) {
        System.arraycopy(this.valueBuffer.array(), position, this.valueBuffer.array(), position + extraBytes, this.valueBuffer.limit() - position);
        this.valueBuffer.limit(this.valueBuffer.limit() + extraBytes);
    }

    private void removeBytesStartingAt(int position, int removedBytes) {
        System.arraycopy(this.valueBuffer.array(), position + removedBytes, this.valueBuffer.array(), position, this.valueBuffer.limit() - position - removedBytes);
        this.valueBuffer.limit(this.valueBuffer.limit() - removedBytes);
    }

    public PythonNone setByte(PythonInteger index, PythonInteger item) {
        int indexAsInt = PythonSlice.asIntIndexForLength(index, this.valueBuffer.limit());
        if (indexAsInt < 0 || indexAsInt >= this.valueBuffer.limit()) {
            throw new IndexError("bytearray index out of range");
        }
        this.valueBuffer.put(indexAsInt, item.asByte());
        return PythonNone.INSTANCE;
    }

    public PythonNone setSlice(PythonSlice slice, PythonLikeObject iterable) {
        byte[] iterableBytes = PythonByteArray.getBytes(iterable);
        if (slice.getStrideLength() == 1) {
            int sizeDifference = iterableBytes.length - slice.getSliceSize(this.valueBuffer.limit());
            if (sizeDifference == 0) {
                this.valueBuffer.position(slice.getStartIndex(this.valueBuffer.limit()));
                this.valueBuffer.put(iterableBytes);
            } else if (sizeDifference > 0) {
                int oldLimit = this.valueBuffer.limit();
                this.ensureCapacity(this.valueBuffer.capacity() + sizeDifference);
                this.insertExtraBytesAt(slice.getStopIndex(oldLimit), sizeDifference);
                System.arraycopy(iterableBytes, 0, this.valueBuffer.array(), slice.getStartIndex(oldLimit), iterableBytes.length);
            } else {
                int oldLimit = this.valueBuffer.limit();
                this.removeBytesStartingAt(slice.getStopIndex(oldLimit) + sizeDifference, -sizeDifference);
                System.arraycopy(iterableBytes, 0, this.valueBuffer.array(), slice.getStartIndex(oldLimit), iterableBytes.length);
            }
        } else if (iterableBytes.length == 0) {
            this.deleteSlice(slice);
        } else {
            if (iterableBytes.length != slice.getSliceSize(this.valueBuffer.limit())) {
                throw new ValueError("attempt to assign bytes of size " + iterableBytes.length + " to extended slice of size " + slice.getSliceSize(this.valueBuffer.limit()));
            }
            slice.iterate(this.valueBuffer.limit(), (index, step) -> this.valueBuffer.put(index, iterableBytes[step]));
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone deleteIndex(PythonInteger index) {
        int indexAsInt = PythonSlice.asIntIndexForLength(index, this.valueBuffer.limit());
        this.removeBytesStartingAt(indexAsInt, 1);
        return PythonNone.INSTANCE;
    }

    public PythonNone deleteSlice(PythonSlice deletedSlice) {
        if (deletedSlice.getStrideLength() == 1) {
            this.removeBytesStartingAt(deletedSlice.getStartIndex(this.valueBuffer.limit()), deletedSlice.getSliceSize(this.valueBuffer.limit()));
        } else if (deletedSlice.getStrideLength() > 0) {
            deletedSlice.iterate(this.valueBuffer.limit(), (index, step) -> this.removeBytesStartingAt(index - step, 1));
        } else {
            deletedSlice.iterate(this.valueBuffer.limit(), (index, step) -> this.removeBytesStartingAt(index, 1));
        }
        return PythonNone.INSTANCE;
    }

    public PythonNone appendByte(PythonInteger addedByte) {
        byte toAdd = addedByte.asByte();
        this.ensureCapacity(this.valueBuffer.limit() + 1);
        this.valueBuffer.limit(this.valueBuffer.limit() + 1);
        this.valueBuffer.position(this.valueBuffer.limit() - 1);
        this.valueBuffer.put(toAdd);
        return PythonNone.INSTANCE;
    }

    public PythonNone clear() {
        this.valueBuffer.limit(0);
        return PythonNone.INSTANCE;
    }

    public PythonByteArray copy() {
        byte[] copiedData = this.asByteArray();
        return new PythonByteArray(copiedData);
    }

    public PythonNone extend(PythonLikeObject iterable) {
        byte[] data = PythonByteArray.getBytes(iterable);
        this.ensureCapacity(this.valueBuffer.limit() + data.length);
        int oldLimit = this.valueBuffer.limit();
        this.valueBuffer.limit(this.valueBuffer.limit() + data.length);
        this.valueBuffer.position(oldLimit);
        this.valueBuffer.put(data);
        return PythonNone.INSTANCE;
    }

    public PythonByteArray inplaceAdd(PythonLikeObject iterable) {
        this.extend(iterable);
        return this;
    }

    public PythonByteArray inplaceRepeat(PythonLikeObject indexable) {
        return this.inplaceRepeat((PythonInteger)UnaryDunderBuiltin.INDEX.invoke(indexable));
    }

    public PythonByteArray inplaceRepeat(PythonInteger index) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt <= 0) {
            this.clear();
            return this;
        }
        if (indexAsInt == 1) {
            return this;
        }
        this.ensureCapacity(this.valueBuffer.limit() * indexAsInt);
        int oldLimit = this.valueBuffer.limit();
        this.valueBuffer.limit(oldLimit * indexAsInt);
        for (int i = 1; i < indexAsInt; ++i) {
            System.arraycopy(this.valueBuffer.array(), 0, this.valueBuffer.array(), i * oldLimit, oldLimit);
        }
        return this;
    }

    public PythonNone insert(PythonInteger index, PythonInteger value) {
        byte toInsert = value.asByte();
        this.ensureCapacity(this.valueBuffer.limit() + 1);
        int indexAsInt = PythonSlice.asIntIndexForLength(index, this.valueBuffer.limit());
        if (indexAsInt < 0) {
            indexAsInt = 0;
        }
        if (indexAsInt > this.valueBuffer.limit()) {
            indexAsInt = this.valueBuffer.limit();
        }
        this.insertExtraBytesAt(indexAsInt, 1);
        this.valueBuffer.position(indexAsInt);
        this.valueBuffer.put(toInsert);
        return PythonNone.INSTANCE;
    }

    public PythonInteger pop() {
        if (this.valueBuffer.limit() == 0) {
            throw new IndexError("pop from empty bytearray");
        }
        PythonInteger out = PythonBytes.BYTE_TO_INT[Byte.toUnsignedInt(this.valueBuffer.get(this.valueBuffer.limit() - 1))];
        this.valueBuffer.limit(this.valueBuffer.limit() - 1);
        return out;
    }

    public PythonInteger pop(PythonInteger index) {
        int indexAsInt = PythonSlice.asIntIndexForLength(index, this.valueBuffer.limit());
        if (this.valueBuffer.limit() == 0) {
            throw new IndexError("pop from empty bytearray");
        }
        if (indexAsInt < 0 || indexAsInt > this.valueBuffer.limit()) {
            throw new IndexError("index out of range for bytearray");
        }
        PythonInteger out = PythonBytes.BYTE_TO_INT[Byte.toUnsignedInt(this.valueBuffer.get(indexAsInt))];
        this.removeBytesStartingAt(indexAsInt, 1);
        return out;
    }

    public PythonNone remove(PythonInteger item) {
        byte queryByte = item.asByte();
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            if (this.valueBuffer.get(i) != queryByte) continue;
            this.removeBytesStartingAt(i, 1);
            return PythonNone.INSTANCE;
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonNone reverse() {
        int limit = this.valueBuffer.limit();
        byte[] data = this.valueBuffer.array();
        for (int i = 0; i < limit >> 1; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - i - 1];
            data[data.length - i - 1] = temp;
        }
        return PythonNone.INSTANCE;
    }

    public boolean hasPrefix(ByteBuffer prefixBytes, int start, int end) {
        if (prefixBytes.limit() > end - start) {
            return false;
        }
        return Arrays.equals(this.valueBuffer.array(), start, start + prefixBytes.limit(), prefixBytes.array(), 0, prefixBytes.limit());
    }

    public boolean hasSuffix(ByteBuffer suffixBytes, int start, int end) {
        if (suffixBytes.limit() > end - start) {
            return false;
        }
        return Arrays.equals(this.valueBuffer.array(), end - suffixBytes.limit(), end, suffixBytes.array(), 0, suffixBytes.limit());
    }

    public PythonByteArray removePrefix(PythonByteArray prefix) {
        return this.hasPrefix(prefix.valueBuffer, 0, this.valueBuffer.limit()) ? new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), prefix.valueBuffer.limit(), this.valueBuffer.limit())) : this;
    }

    public PythonByteArray removeSuffix(PythonByteArray suffix) {
        return this.hasSuffix(suffix.valueBuffer, 0, this.valueBuffer.limit()) ? new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), 0, this.valueBuffer.limit() - suffix.valueBuffer.limit())) : this;
    }

    public PythonString decode() {
        try {
            return PythonString.valueOf(StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(this.valueBuffer).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonString decode(PythonString charset) {
        try {
            return PythonString.valueOf(Charset.forName(charset.value).newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(this.valueBuffer).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonString decode(PythonString charset, PythonString errorActionString) {
        CodingErrorAction errorAction = switch (errorActionString.value) {
            case "strict" -> CodingErrorAction.REPORT;
            case "ignore" -> CodingErrorAction.IGNORE;
            case "replace" -> CodingErrorAction.REPLACE;
            default -> throw new ValueError(String.valueOf(errorActionString.repr()) + " is not a valid value for errors. Possible values are: \"strict\", \"ignore\", \"replace\".");
        };
        try {
            return PythonString.valueOf(Charset.forName(charset.value).newDecoder().onMalformedInput(errorAction).decode(this.valueBuffer).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonBoolean endsWith(PythonByteArray suffix) {
        return PythonBoolean.valueOf(this.hasSuffix(suffix.valueBuffer, 0, this.valueBuffer.limit()));
    }

    public PythonBoolean endsWith(PythonByteArray suffix, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return PythonBoolean.valueOf(this.hasSuffix(suffix.valueBuffer, startAsInt, this.valueBuffer.limit()));
    }

    public PythonBoolean endsWith(PythonByteArray suffix, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return PythonBoolean.valueOf(this.hasSuffix(suffix.valueBuffer, startAsInt, endAsInt));
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonByteArray> suffixes) {
        for (PythonByteArray suffix : suffixes) {
            if (!this.hasSuffix(suffix.valueBuffer, 0, this.valueBuffer.limit())) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonByteArray> suffixes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        for (PythonByteArray suffix : suffixes) {
            if (!this.hasSuffix(suffix.valueBuffer, startAsInt, this.valueBuffer.limit())) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonByteArray> suffixes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        for (PythonByteArray suffix : suffixes) {
            if (!this.hasSuffix(suffix.valueBuffer, startAsInt, endAsInt)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    private PythonInteger find(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = start; i < end; ++i) {
            if (this.valueBuffer.get(i) != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger index(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = start; i < end; ++i) {
            if (this.valueBuffer.get(i) != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger find(PythonInteger query) {
        return this.find(query, 0, this.valueBuffer.limit());
    }

    public PythonInteger find(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.find(query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger find(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.find(query, startAsInt, endAsInt);
    }

    public PythonInteger index(PythonInteger query) {
        return this.index(query, 0, this.valueBuffer.limit());
    }

    public PythonInteger index(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.index(query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger index(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.index(query, startAsInt, endAsInt);
    }

    private PythonInteger find(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        if (queryBytes.length == 0) {
            return this.valueBuffer.limit() > 0 ? PythonInteger.ZERO : PythonInteger.valueOf(-1);
        }
        for (int i = start; i <= end - queryBytes.length; ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + queryBytes.length, queryBytes, 0, queryBytes.length)) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger index(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        if (queryBytes.length == 0) {
            if (this.valueBuffer.limit() > 0) {
                return PythonInteger.ZERO;
            }
            throw new ValueError("Subsequence not found");
        }
        for (int i = start; i <= end - queryBytes.length; ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + queryBytes.length, queryBytes, 0, queryBytes.length)) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger find(PythonByteArray query) {
        return this.find((PythonBytesLikeObject)query, 0, this.valueBuffer.limit());
    }

    public PythonInteger find(PythonByteArray query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.find((PythonBytesLikeObject)query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger find(PythonByteArray query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.find((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonInteger index(PythonByteArray query) {
        return this.index((PythonBytesLikeObject)query, 0, this.valueBuffer.limit());
    }

    public PythonInteger index(PythonByteArray query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.index((PythonBytesLikeObject)query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger index(PythonByteArray query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.index((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonByteArray interpolate(PythonLikeObject object) {
        if (object instanceof PythonLikeTuple) {
            return this.interpolate((PythonLikeTuple)object);
        }
        if (object instanceof PythonLikeDict) {
            return this.interpolate((PythonLikeDict)object);
        }
        return this.interpolate(PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{object}));
    }

    public PythonByteArray interpolate(PythonLikeTuple tuple) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.asCharSequence(), tuple, StringFormatter.PrintfStringType.BYTES)).asAsciiByteArray();
    }

    public PythonByteArray interpolate(PythonLikeDict dict) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.asCharSequence(), dict, StringFormatter.PrintfStringType.BYTES)).asAsciiByteArray();
    }

    public PythonByteArray join(PythonLikeObject iterable) {
        PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(iterable);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while (iterator.hasNext()) {
            PythonLikeObject item = iterator.nextPythonItem();
            if (!(item instanceof PythonBytesLikeObject)) {
                throw new TypeError("type " + String.valueOf(item.$getType()) + " is not a bytes-like type");
            }
            outputStream.writeBytes(((PythonBytesLikeObject)item).asByteArray());
            if (!iterator.hasNext()) continue;
            outputStream.write(this.valueBuffer.array(), 0, this.valueBuffer.limit());
        }
        return new PythonByteArray(outputStream.toByteArray());
    }

    private PythonLikeTuple partition(PythonBytesLikeObject sep, int start, int end) {
        byte[] sepBytes = sep.asByteArray();
        for (int i = start; i < end - sepBytes.length; ++i) {
            int j;
            for (j = 0; j < sepBytes.length && this.valueBuffer.get(i + j) == sepBytes[j]; ++j) {
            }
            if (j != sepBytes.length) continue;
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytesLikeObject[]{new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), 0, i)), sep, new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), i + sepBytes.length, this.valueBuffer.limit()))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonByteArray[]{this, new PythonByteArray(new byte[0]), new PythonByteArray(new byte[0])});
    }

    public PythonLikeTuple partition(PythonByteArray sep) {
        return this.partition((PythonBytesLikeObject)sep, 0, this.valueBuffer.limit());
    }

    public PythonLikeTuple partition(PythonByteArray sep, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.partition((PythonBytesLikeObject)sep, startAsInt, this.valueBuffer.limit());
    }

    public PythonLikeTuple partition(PythonByteArray sep, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidStartIntIndexForLength(end, this.valueBuffer.limit());
        return this.partition((PythonBytesLikeObject)sep, startAsInt, endAsInt);
    }

    public PythonByteArray replace(PythonBytesLikeObject old, PythonBytesLikeObject replacement) {
        byte[] oldBytes = old.asByteArray();
        byte[] replacementBytes = replacement.asByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int lastReplacementEnd = 0;
        for (int i = 0; i < this.valueBuffer.limit() - oldBytes.length; ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + oldBytes.length, oldBytes, 0, oldBytes.length)) continue;
            outputStream.write(this.valueBuffer.array(), lastReplacementEnd, i - lastReplacementEnd);
            outputStream.writeBytes(replacementBytes);
            lastReplacementEnd = i += oldBytes.length;
        }
        outputStream.write(this.valueBuffer.array(), lastReplacementEnd, this.valueBuffer.limit() - lastReplacementEnd);
        return new PythonByteArray(outputStream.toByteArray());
    }

    public PythonByteArray replace(PythonBytesLikeObject old, PythonBytesLikeObject replacement, BigInteger count) {
        byte[] oldBytes = old.asByteArray();
        byte[] replacementBytes = replacement.asByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int lastReplacementEnd = 0;
        for (int i = 0; i < this.valueBuffer.limit() - oldBytes.length && count.compareTo(BigInteger.ZERO) != 0; ++i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + oldBytes.length, oldBytes, 0, oldBytes.length)) continue;
            outputStream.write(this.valueBuffer.array(), lastReplacementEnd, i - lastReplacementEnd);
            outputStream.writeBytes(replacementBytes);
            lastReplacementEnd = i += oldBytes.length;
            count = count.subtract(BigInteger.ONE);
        }
        outputStream.write(this.valueBuffer.array(), lastReplacementEnd, this.valueBuffer.limit() - lastReplacementEnd);
        return new PythonByteArray(outputStream.toByteArray());
    }

    public PythonByteArray replace(PythonByteArray old, PythonByteArray replacement) {
        return this.replace((PythonBytesLikeObject)old, (PythonBytesLikeObject)replacement);
    }

    public PythonByteArray replace(PythonByteArray old, PythonByteArray replacement, PythonInteger count) {
        return this.replace((PythonBytesLikeObject)old, (PythonBytesLikeObject)replacement, count.value);
    }

    private PythonInteger rightFind(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = end - 1; i >= start; --i) {
            if (this.valueBuffer.get(i) != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger rightIndex(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = end - 1; i >= start; --i) {
            if (this.valueBuffer.get(i) != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger rightFind(PythonInteger query) {
        return this.rightFind(query, 0, this.valueBuffer.limit());
    }

    public PythonInteger rightFind(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.rightFind(query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger rightFind(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.rightFind(query, startAsInt, endAsInt);
    }

    public PythonInteger rightIndex(PythonInteger query) {
        return this.rightIndex(query, 0, this.valueBuffer.limit());
    }

    public PythonInteger rightIndex(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.rightIndex(query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger rightIndex(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.rightIndex(query, startAsInt, endAsInt);
    }

    private PythonInteger rightFind(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        for (int i = end - queryBytes.length; i >= start; --i) {
            int j;
            for (j = 0; j < queryBytes.length && this.valueBuffer.get(i + j) == queryBytes[j]; ++j) {
            }
            if (j != queryBytes.length) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger rightIndex(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        for (int i = end - queryBytes.length; i >= start; --i) {
            int j;
            for (j = 0; j < queryBytes.length && this.valueBuffer.get(i + j) == queryBytes[j]; ++j) {
            }
            if (j != queryBytes.length) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger rightFind(PythonByteArray query) {
        return this.rightFind((PythonBytesLikeObject)query, 0, this.valueBuffer.limit());
    }

    public PythonInteger rightFind(PythonByteArray query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.rightFind((PythonBytesLikeObject)query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger rightFind(PythonByteArray query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.rightFind((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonInteger rightIndex(PythonByteArray query) {
        return this.rightIndex((PythonBytesLikeObject)query, 0, this.valueBuffer.limit());
    }

    public PythonInteger rightIndex(PythonByteArray query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return this.rightIndex((PythonBytesLikeObject)query, startAsInt, this.valueBuffer.limit());
    }

    public PythonInteger rightIndex(PythonByteArray query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return this.rightIndex((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    private PythonLikeTuple rightPartition(PythonBytesLikeObject sep, int start, int end) {
        byte[] sepBytes = sep.asByteArray();
        for (int i = end - sepBytes.length; i >= start; --i) {
            if (!Arrays.equals(this.valueBuffer.array(), i, i + sepBytes.length, sepBytes, 0, sepBytes.length)) continue;
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytesLikeObject[]{new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), 0, i)), sep, new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), i + sepBytes.length, this.valueBuffer.limit()))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonByteArray[]{new PythonByteArray(new byte[0]), new PythonByteArray(new byte[0]), this});
    }

    public PythonLikeTuple rightPartition(PythonByteArray sep) {
        return this.rightPartition(sep, 0, this.valueBuffer.limit());
    }

    public PythonBoolean startsWith(PythonByteArray prefix) {
        return PythonBoolean.valueOf(this.hasPrefix(prefix.valueBuffer, 0, this.valueBuffer.limit()));
    }

    public PythonBoolean startsWith(PythonByteArray prefix, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        return PythonBoolean.valueOf(this.hasPrefix(prefix.valueBuffer, startAsInt, this.valueBuffer.limit()));
    }

    public PythonBoolean startsWith(PythonByteArray prefix, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        return PythonBoolean.valueOf(this.hasPrefix(prefix.valueBuffer, startAsInt, endAsInt));
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonByteArray> prefixes) {
        for (PythonByteArray prefix : prefixes) {
            if (!this.hasPrefix(prefix.valueBuffer, 0, this.valueBuffer.limit())) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonByteArray> prefixes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        for (PythonByteArray prefix : prefixes) {
            if (!this.hasPrefix(prefix.valueBuffer, startAsInt, this.valueBuffer.limit())) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonByteArray> prefixes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.valueBuffer.limit());
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.valueBuffer.limit());
        for (PythonByteArray prefix : prefixes) {
            if (!this.hasPrefix(prefix.valueBuffer, startAsInt, endAsInt)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonByteArray translate(PythonBytes table) {
        byte[] tableBytes = table.value;
        if (tableBytes.length != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        byte[] out = new byte[this.valueBuffer.limit()];
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            out[i] = tableBytes[this.valueBuffer.get(i) & 0xFF];
        }
        return new PythonByteArray(out);
    }

    public PythonByteArray translate(PythonByteArray table) {
        if (table.valueBuffer.limit() != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        byte[] out = new byte[this.valueBuffer.limit()];
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            out[i] = table.valueBuffer.get(this.valueBuffer.get(i) & 0xFF);
        }
        return new PythonByteArray(out);
    }

    public PythonByteArray translate(PythonNone table) {
        return this;
    }

    public PythonByteArray translate(PythonBytes table, PythonByteArray delete) {
        byte[] tableBytes = table.value;
        if (tableBytes.length != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.valueBuffer.limit());
        BitSet removedSet = PythonByteArray.asBitSet(delete);
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            byte b = this.valueBuffer.get(i);
            if (removedSet.get(b & 0xFF)) continue;
            out.write(tableBytes, b & 0xFF, 1);
        }
        return new PythonByteArray(out.toByteArray());
    }

    public PythonByteArray translate(PythonNone table, PythonByteArray delete) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.valueBuffer.limit());
        BitSet removedSet = PythonByteArray.asBitSet(delete);
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            if (removedSet.get(this.valueBuffer.get(i) & 0xFF)) continue;
            out.write(this.valueBuffer.array(), i, 1);
        }
        return new PythonByteArray(out.toByteArray());
    }

    public PythonByteArray translate(PythonByteArray table, PythonByteArray delete) {
        if (table.valueBuffer.limit() != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.valueBuffer.limit());
        BitSet removedSet = PythonByteArray.asBitSet(delete);
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            byte b = this.valueBuffer.get(i);
            if (removedSet.get(b & 0xFF)) continue;
            out.write(table.valueBuffer.array(), b & 0xFF, 1);
        }
        return new PythonByteArray(out.toByteArray());
    }

    public PythonByteArray center(PythonInteger fillWidth) {
        return this.center(fillWidth, ASCII_SPACE);
    }

    public PythonByteArray center(PythonInteger fillWidth, PythonByteArray fillCharacter) {
        if (fillCharacter.valueBuffer.limit() != 1) {
            throw new TypeError("center() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.valueBuffer.limit()) {
            return this;
        }
        int extraWidth = widthAsInt - this.valueBuffer.limit();
        int rightPadding = extraWidth / 2;
        int leftPadding = rightPadding + (extraWidth & 1);
        byte[] out = new byte[widthAsInt];
        Arrays.fill(out, 0, leftPadding, fillCharacter.valueBuffer.get(0));
        System.arraycopy(this.valueBuffer.array(), 0, out, leftPadding, this.valueBuffer.limit());
        Arrays.fill(out, leftPadding + this.valueBuffer.limit(), widthAsInt, fillCharacter.valueBuffer.get(0));
        return new PythonByteArray(out);
    }

    public PythonByteArray leftJustify(PythonInteger fillWidth) {
        return this.leftJustify(fillWidth, ASCII_SPACE);
    }

    public PythonByteArray leftJustify(PythonInteger fillWidth, PythonByteArray fillCharacter) {
        if (fillCharacter.valueBuffer.limit() != 1) {
            throw new TypeError("ljust() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.valueBuffer.limit()) {
            return this;
        }
        byte[] out = new byte[widthAsInt];
        System.arraycopy(this.valueBuffer.array(), 0, out, 0, this.valueBuffer.limit());
        Arrays.fill(out, this.valueBuffer.limit(), widthAsInt, fillCharacter.valueBuffer.get(0));
        return new PythonByteArray(out);
    }

    public PythonByteArray rightJustify(PythonInteger fillWidth) {
        return this.rightJustify(fillWidth, ASCII_SPACE);
    }

    public PythonByteArray rightJustify(PythonInteger fillWidth, PythonByteArray fillCharacter) {
        if (fillCharacter.valueBuffer.limit() != 1) {
            throw new TypeError("rjust() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.valueBuffer.limit()) {
            return this;
        }
        int extraWidth = widthAsInt - this.valueBuffer.limit();
        byte[] out = new byte[widthAsInt];
        Arrays.fill(out, 0, extraWidth, fillCharacter.valueBuffer.get(0));
        System.arraycopy(this.valueBuffer.array(), 0, out, extraWidth, this.valueBuffer.limit());
        return new PythonByteArray(out);
    }

    public PythonByteArray strip() {
        return this.strip(ASCII_SPACE);
    }

    public PythonByteArray strip(PythonNone ignored) {
        return this.strip();
    }

    public PythonByteArray strip(PythonByteArray bytesToStrip) {
        int start;
        BitSet toStrip = PythonByteArray.asBitSet(bytesToStrip);
        int end = this.valueBuffer.limit() - 1;
        for (start = 0; start < this.valueBuffer.limit() && toStrip.get(this.valueBuffer.get(start) & 0xFF); ++start) {
        }
        while (end >= start && toStrip.get(this.valueBuffer.get(end) & 0xFF)) {
            --end;
        }
        if (end < start) {
            return new PythonByteArray(new byte[0]);
        }
        return new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), start, end + 1));
    }

    public PythonByteArray leftStrip() {
        return this.leftStrip(ASCII_SPACE);
    }

    public PythonByteArray leftStrip(PythonNone ignored) {
        return this.leftStrip();
    }

    public PythonByteArray leftStrip(PythonByteArray bytesToStrip) {
        int start;
        BitSet toStrip = PythonByteArray.asBitSet(bytesToStrip);
        for (start = 0; start < this.valueBuffer.limit() && toStrip.get(this.valueBuffer.get(start) & 0xFF); ++start) {
        }
        if (start == this.valueBuffer.limit()) {
            return new PythonByteArray(new byte[0]);
        }
        return new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), start, this.valueBuffer.limit()));
    }

    public PythonByteArray rightStrip() {
        return this.rightStrip(ASCII_SPACE);
    }

    public PythonByteArray rightStrip(PythonNone ignored) {
        return this.rightStrip();
    }

    public PythonByteArray rightStrip(PythonByteArray bytesToStrip) {
        int end;
        BitSet toStrip = PythonByteArray.asBitSet(bytesToStrip);
        for (end = this.valueBuffer.limit() - 1; end >= 0 && toStrip.get(this.valueBuffer.get(end) & 0xFF); --end) {
        }
        if (end < 0) {
            return new PythonByteArray(new byte[0]);
        }
        return new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), 0, end + 1));
    }

    public PythonLikeList<PythonByteArray> split() {
        int end;
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        int start = 0;
        for (end = this.valueBuffer.limit(); end > 0 && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(end - 1) & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(start) & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(start) & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            start = lastEnd = start + 1;
        }
        if (lastEnd != end) {
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, end)));
        }
        return out;
    }

    public PythonLikeList<PythonByteArray> split(PythonNone ignored) {
        return this.split();
    }

    public PythonLikeList<PythonByteArray> split(PythonByteArray seperator) {
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        int start = 0;
        int end = this.valueBuffer.limit();
        int lastEnd = start;
        while (start < end - seperator.valueBuffer.limit()) {
            while (start < end - seperator.valueBuffer.limit() && !Arrays.equals(this.valueBuffer.array(), start, start + seperator.valueBuffer.limit(), seperator.valueBuffer.array(), 0, seperator.valueBuffer.limit())) {
                ++start;
            }
            if (start == end - seperator.valueBuffer.limit()) continue;
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            start = lastEnd = start + seperator.valueBuffer.limit();
        }
        if (Arrays.equals(this.valueBuffer.array(), start, start + seperator.valueBuffer.limit(), seperator.valueBuffer.array(), 0, seperator.valueBuffer.limit())) {
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            lastEnd = start + seperator.valueBuffer.limit();
        }
        out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, end)));
        return out;
    }

    public PythonLikeList<PythonByteArray> split(PythonByteArray seperator, PythonInteger maxSplits) {
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        int start = 0;
        int end = this.valueBuffer.limit();
        int lastEnd = start;
        while (start < end - seperator.valueBuffer.limit() && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - seperator.valueBuffer.limit() && !Arrays.equals(this.valueBuffer.array(), start, start + seperator.valueBuffer.limit(), seperator.valueBuffer.array(), 0, seperator.valueBuffer.limit())) {
                ++start;
            }
            if (start == end - seperator.valueBuffer.limit()) continue;
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            start = lastEnd = start + seperator.valueBuffer.limit();
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (maxSplits.compareTo(PythonInteger.ONE) >= 0 && Arrays.equals(this.valueBuffer.array(), start, start + seperator.valueBuffer.limit(), seperator.valueBuffer.array(), 0, seperator.valueBuffer.limit())) {
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            lastEnd = start + seperator.valueBuffer.limit();
        }
        out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, end)));
        return out;
    }

    public PythonLikeList<PythonByteArray> split(PythonNone seperator, PythonInteger maxSplits) {
        int end;
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        int start = 0;
        for (end = this.valueBuffer.limit(); end > 0 && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(end - 1) & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(start) & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1 && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(start) & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, start)));
            start = lastEnd = start + 1;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (lastEnd != end) {
            out.add(new PythonByteArray(Arrays.copyOfRange(this.valueBuffer.array(), lastEnd, end)));
        }
        return out;
    }

    public PythonLikeList<PythonByteArray> rightSplit() {
        return this.split();
    }

    public PythonLikeList<PythonByteArray> rightSplit(PythonNone ignored) {
        return this.rightSplit();
    }

    public PythonLikeList<PythonByteArray> rightSplit(PythonByteArray seperator) {
        return this.split(seperator);
    }

    private static byte[] reverseInplace(byte[] array) {
        for (int i = 0; i < array.length >> 1; ++i) {
            byte temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }

    public PythonLikeList<PythonByteArray> rightSplit(PythonByteArray seperator, PythonInteger maxSplits) {
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        byte[] reversedValue = PythonByteArray.reverseInplace((byte[])this.valueBuffer.array().clone());
        byte[] reversedSep = PythonByteArray.reverseInplace((byte[])seperator.valueBuffer.array().clone());
        int start = 0;
        int end = reversedValue.length;
        int lastEnd = start;
        while (start < end - reversedSep.length && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - reversedSep.length && !Arrays.equals(reversedValue, start, start + reversedSep.length, reversedSep, 0, reversedSep.length)) {
                ++start;
            }
            if (start == end - reversedSep.length) continue;
            out.add(new PythonByteArray(PythonByteArray.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            start = lastEnd = start + reversedSep.length;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (maxSplits.compareTo(PythonInteger.ONE) >= 0 && Arrays.equals(reversedValue, start, start + reversedSep.length, reversedSep, 0, reversedSep.length)) {
            out.add(new PythonByteArray(PythonByteArray.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            lastEnd = start + seperator.valueBuffer.limit();
        }
        out.add(new PythonByteArray(PythonByteArray.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, end))));
        out.reverse();
        return out;
    }

    public PythonLikeList<PythonByteArray> rightSplit(PythonNone seperator, PythonInteger maxSplits) {
        int end;
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonByteArray> out = new PythonLikeList<PythonByteArray>();
        byte[] reversedValue = PythonByteArray.reverseInplace(Arrays.copyOfRange(this.valueBuffer.array(), 0, this.valueBuffer.limit()));
        int start = 0;
        for (end = this.valueBuffer.limit(); end > 0 && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(end - 1) & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.valueBuffer.get(start) & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1 && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(reversedValue[start] & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonByteArray(PythonByteArray.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            start = lastEnd = start + 1;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (lastEnd != end) {
            out.add(new PythonByteArray(PythonByteArray.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, end))));
        }
        out.reverse();
        return out;
    }

    public PythonByteArray capitalize() {
        PythonString asString = this.asAsciiString();
        if (asString.value.isEmpty()) {
            return asString.asAsciiByteArray();
        }
        String tail = PythonString.valueOf((String)asString.value.substring((int)1)).withModifiedCodepoints((IntUnaryOperator)(IntUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$capitalize$8(int ), (I)I)()).value;
        char head = asString.value.charAt(0);
        if (head < '\u0080') {
            head = Character.toTitleCase(head);
        }
        return PythonString.valueOf(head + tail).asAsciiByteArray();
    }

    public PythonByteArray expandTabs() {
        return this.asAsciiString().expandTabs().asAsciiByteArray();
    }

    public PythonByteArray expandTabs(PythonInteger tabSize) {
        return this.asAsciiString().expandTabs(tabSize).asAsciiByteArray();
    }

    public PythonBoolean isAlphaNumeric() {
        return this.asAsciiString().isAlphaNumeric();
    }

    public PythonBoolean isAlpha() {
        return this.asAsciiString().isAlpha();
    }

    public PythonBoolean isAscii() {
        for (int i = 0; i < this.valueBuffer.limit(); ++i) {
            byte b = this.valueBuffer.get(i);
            if ((b & 0xFF) <= 127) continue;
            return PythonBoolean.FALSE;
        }
        return PythonBoolean.TRUE;
    }

    public PythonBoolean isDigit() {
        return this.asAsciiString().isDigit();
    }

    public PythonBoolean isLower() {
        return this.asAsciiString().isLower();
    }

    public PythonBoolean isSpace() {
        return this.asAsciiString().isSpace();
    }

    public PythonBoolean isTitle() {
        return this.asAsciiString().isTitle();
    }

    public PythonBoolean isUpper() {
        return this.asAsciiString().isUpper();
    }

    public PythonByteArray lower() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? Character.toLowerCase(cp) : cp).asAsciiByteArray();
    }

    public PythonLikeList<PythonByteArray> splitLines() {
        return this.asAsciiString().splitLines().stream().map(PythonString::asAsciiByteArray).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonByteArray> splitLines(PythonBoolean keepEnds) {
        return this.asAsciiString().splitLines(keepEnds).stream().map(PythonString::asAsciiByteArray).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonByteArray swapCase() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? PythonString.CharacterCase.swapCase(cp) : cp).asAsciiByteArray();
    }

    public PythonByteArray title() {
        return this.asAsciiString().title(cp -> cp < 128).asAsciiByteArray();
    }

    public PythonByteArray upper() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? Character.toUpperCase(cp) : cp).asAsciiByteArray();
    }

    public PythonByteArray zfill(PythonInteger width) {
        return this.asAsciiString().zfill(width).asAsciiByteArray();
    }

    public PythonString asString() {
        return PythonString.valueOf(this.toString());
    }

    public PythonString repr() {
        return this.asString();
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(this.valueBuffer.limit());
        out.append("bytearray(");
        out.append(new PythonBytes((byte[])Arrays.copyOfRange((byte[])this.valueBuffer.array(), (int)0, (int)this.valueBuffer.limit())).repr().value);
        out.append(")");
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonByteArray that = (PythonByteArray)o;
        return this.valueBuffer.equals(that.valueBuffer);
    }

    public int hashCode() {
        return this.valueBuffer.hashCode();
    }

    private static /* synthetic */ int lambda$capitalize$8(int cp) {
        return cp < 128 ? Character.toLowerCase(cp) : cp;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonByteArray::registerMethods);
    }
}

