/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.object;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.ObjectImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;

public class LoadSuperAttrOpcode
extends AbstractOpcode {
    final int nameIndex;
    final boolean isLoadMethod;
    final boolean isTwoArgSuper;

    public LoadSuperAttrOpcode(PythonBytecodeInstruction instruction) {
        super(instruction);
        this.nameIndex = instruction.arg() >> 2;
        this.isLoadMethod = (instruction.arg() & 1) == 1;
        this.isTwoArgSuper = (instruction.arg() & 2) == 2;
    }

    @Override
    protected StackMetadata getStackMetadataAfterInstruction(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        if (this.isLoadMethod) {
            return stackMetadata.pop(3).push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.BASE_TYPE, stackMetadata.getValueSourcesUpToStackIndex(3))).push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.BASE_TYPE, stackMetadata.getValueSourcesUpToStackIndex(3)));
        }
        return stackMetadata.pop(3).push(ValueSourceInfo.of((Opcode)this, BuiltinTypes.BASE_TYPE, stackMetadata.getValueSourcesUpToStackIndex(3)));
    }

    @Override
    public void implement(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        ObjectImplementor.getSuperAttribute(functionMetadata, stackMetadata, this.nameIndex, this.isLoadMethod);
    }
}

