package com.particles.mes.android

import com.google.protobuf.MessageLite
import okhttp3.*
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody
import java.util.concurrent.TimeUnit

internal object EventTracker : Tracker() {
    fun track(url: String, msg: MessageLite) {
        track(url, "application/x-protobuf", msg.toByteArray())
    }
}

internal abstract class Tracker {

    fun track(url: String, mediaType: String, body: ByteArray) {
        val requestBody = body.toRequestBody(mediaType.toMediaTypeOrNull())

        val request = Request.Builder()
            .url(url)
            .header("User-Agent", httpAgent)
            .post(requestBody)
            .build()

        okHttpClient.newCall(request).execute().use {
            if (BuildConfig.DEBUG) {
                println("Response of $url")
                println("${it.code}: ${it.message}")
                println("${it.body?.string()}")
            }
        }
    }

    fun track(url: String) {
        val request = Request.Builder().url(url).header("User-Agent", httpAgent).build()
        okHttpClient.newCall(request).execute().use {
            if (BuildConfig.DEBUG) {
                println("Response of $url")
                println("${it.code}: ${it.message}")
                println("${it.body?.string()}")
            }
        }
    }

    companion object {
        private val okHttpClient by lazy {
            MesConfig.okHttpClient ?: OkHttpClient.Builder()
                .connectTimeout(4, TimeUnit.SECONDS)
                .writeTimeout(8, TimeUnit.SECONDS)
                .readTimeout(8, TimeUnit.SECONDS)
                .build()
        }
        private val httpAgent by lazy { System.getProperty("http.agent") ?: "" }
    }
}
