package com.particles.mes.android

import android.util.Log
import com.particles.mes.android.data.MesAdHideEvent
import com.particles.mes.android.data.MesAdImpressionEvent
import com.particles.mes.android.data.MesAdReportEvent
import com.particles.mes.android.data.mapper.EventMapper
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class MesTracker(apiHost: String) {
    private val baseUrl = apiHost.trimEnd('/') + "/v1/event"

    fun trackAdImpression(event: MesAdImpressionEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_impression"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdImpression: $e", e)
                }
            }
        }
    }

    fun trackAdHide(event: MesAdHideEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_hide"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdHide: $e", e)
                }
            }
        }
    }

    fun trackAdReport(event: MesAdReportEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_report"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdReport: $e", e)
                }
            }
        }
    }

    companion object {
        private const val TAG = "MesTracker"
        private val trackers = mutableMapOf<String, MesTracker>()

        fun obtain(apiHost: String): MesTracker {
            return trackers[apiHost] ?: MesTracker(apiHost).also { trackers[apiHost] = it }
        }
    }
}
