package com.particles.mes.android

import android.util.Log
import com.particles.mes.android.data.MesAdClickEvent
import com.particles.mes.android.data.MesAdHideEvent
import com.particles.mes.android.data.MesAdImpressionEvent
import com.particles.mes.android.data.MesAdReportEvent
import com.particles.mes.android.data.MesAdRequestEvent
import com.particles.mes.android.data.MesAdResponseEvent
import com.particles.mes.android.data.MesGetAdEvent
import com.particles.mes.android.data.MesLoadAdEvent
import com.particles.mes.android.data.MesSdkInitEvent
import com.particles.mes.android.data.MesUserSignalEvent
import com.particles.mes.android.data.mapper.EventMapper
import com.particles.mes.protos.GetAdEvent
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class MesTracker(apiHost: String) {
    private val baseUrl = apiHost.trimEnd('/') + "/v1/event"

    fun trackAdImpression(event: MesAdImpressionEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_impression"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdImpression: $e", e)
                }
            }
        }
    }

    fun trackSdkInit(event: MesSdkInitEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/sdk_init"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackSdkInit: $e", e)
                }
            }
        }
    }

    fun trackUserSignal(event: MesUserSignalEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/user_signal"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackUserSignal: $e", e)
                }
            }
        }
    }

    fun trackLoadAd(event: MesLoadAdEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/load_ad"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackLoadAd: $e", e)
                }
            }
        }
    }

    fun trackGetAd(event: MesGetAdEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/get_ad"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackGetAd: $e", e)
                }
            }
        }
    }

    fun trackGetAd(event: GetAdEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/get_ad"
                EventTracker.track(endpoint, event)
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackGetAd: $e", e)
                }
            }
        }
    }

    fun trackAdRequest(event: MesAdRequestEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_request"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdRequest: $e", e)
                }
            }
        }
    }

    fun trackAdResponse(event: MesAdResponseEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_response"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdResponse: $e", e)
                }
            }
        }
    }

    fun trackAdClick(event: MesAdClickEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_click"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdClick: $e", e)
                }
            }
        }
    }

    fun trackAdHide(event: MesAdHideEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_hide"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdHide: $e", e)
                }
            }
        }
    }

    fun trackAdReport(event: MesAdReportEvent) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                val endpoint = "$baseUrl/ad_report"
                EventTracker.track(endpoint, EventMapper.map(event))
            } catch (e: Exception) {
                if (MesConfig.debug) {
                    Log.e(TAG, "trackAdReport: $e", e)
                }
            }
        }
    }

    companion object {
        private const val TAG = "MesTracker"
        private val trackers = mutableMapOf<String, MesTracker>()

        fun obtain(apiHost: String): MesTracker {
            return trackers[apiHost] ?: MesTracker(apiHost).also { trackers[apiHost] = it }
        }
    }
}
