/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.zoo.cv.objectdetction;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.translator.SingleShotDetectionTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.tensorflow.zoo.TfModelZoo;
import ai.djl.tensorflow.zoo.cv.objectdetction.TfSsdTranslator;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public class SingleShotDetectionModelLoader
extends BaseModelLoader<Image, DetectedObjects> {
    private static final Application APPLICATION = Application.CV.OBJECT_DETECTION;
    private static final String GROUP_ID = "ai.djl.tensorflow";
    private static final String ARTIFACT_ID = "ssd";
    private static final String VERSION = "0.0.1";

    public SingleShotDetectionModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION, (ModelZoo)new TfModelZoo());
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair(Image.class, DetectedObjects.class), factory);
        this.factories.put(new Pair(Path.class, DetectedObjects.class), new FileTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(URL.class, DetectedObjects.class), new UrlTranslatorFactory((TranslatorFactory)factory));
        this.factories.put(new Pair(InputStream.class, DetectedObjects.class), new InputStreamTranslatorFactory((TranslatorFactory)factory));
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<Image, DetectedObjects> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, DetectedObjects> {
        private FactoryImpl() {
        }

        public Translator<Image, DetectedObjects> newInstance(Model model, Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 256)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 256)).intValue();
            double threshold = (Double)arguments.getOrDefault("threshold", 0.4);
            return ((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)TfSsdTranslator.builder().optMaxBoxes(10).optThreshold((float)threshold)).optSynsetArtifactName("classes.txt")).addTransform((Transform)new Resize(width, height))).addTransform((Transform)new ToTensor())).build();
        }
    }
}

