/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.zoo;

import ai.djl.Application;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TfModelZoo
implements ModelZoo {
    private static final String DJL_REPO_URL = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"TensorFlow", (String)"https://mlrepo.djl.ai/");
    private static final TfModelZoo ZOO = new TfModelZoo();
    public static final String GROUP_ID = "ai.djl.tensorflow";
    private static final List<ModelLoader> MODEL_LOADERS = new ArrayList<ModelLoader>();

    public List<ModelLoader> getModelLoaders() {
        return MODEL_LOADERS;
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("TensorFlow");
    }

    static {
        MRL resnet = MRL.model((Application)Application.CV.IMAGE_CLASSIFICATION, (String)GROUP_ID, (String)"resnet");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, resnet, "0.0.1", (ModelZoo)ZOO));
        MRL mobilenet = MRL.model((Application)Application.CV.IMAGE_CLASSIFICATION, (String)GROUP_ID, (String)"mobilenet");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, mobilenet, "0.0.1", (ModelZoo)ZOO));
        MRL ssd = MRL.model((Application)Application.CV.OBJECT_DETECTION, (String)GROUP_ID, (String)"ssd");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, ssd, "0.0.1", (ModelZoo)ZOO));
    }
}

