/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine.javacpp;

import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "jnitensorflow";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.getLibName();
        if (libName != null) {
            logger.debug("Loading TensorFlow library from: {}", (Object)libName);
            String path = new File(libName).getParentFile().toString();
            System.setProperty("org.bytedeco.javacpp.platform.preloadpath", path);
            System.setProperty("org.bytedeco.javacpp.maxBytes", "0");
            System.setProperty("org.bytedeco.javacpp.maxPhysicalBytes", "0");
        }
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null) {
            libName = LibUtils.findLibraryInClasspath();
        }
        return libName;
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("TENSORFLOW_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static synchronized String findLibraryInClasspath() {
        Platform platform = Platform.detectPlatform((String)"tensorflow");
        if (platform.isPlaceholder()) {
            return LibUtils.downloadTensorFlow(platform);
        }
        return LibUtils.loadLibraryFromClasspath(platform);
    }

    private static String loadLibraryFromClasspath(Platform platform) {
        String string;
        block15: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)"tensorflow");
                String version = platform.getVersion();
                String flavor = platform.getFlavor();
                String classifier = platform.getClassifier();
                Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
                logger.debug("Using cache dir: {}", (Object)dir);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block15;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract Tensorflow native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        String mapLibraryName = System.mapLibraryName(LIB_NAME);
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && p.getName().endsWith(mapLibraryName)) {
                return p.getAbsolutePath();
            }
            File file = new File(path, mapLibraryName);
            if (!file.exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String downloadTensorFlow(Platform platform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean downloadFiles(List<String> lines, String link, String os, String flavor, Path tmp) throws IOException {
        boolean found = false;
        for (String line : lines) {
            if (!line.startsWith(os + '/' + flavor + '/')) continue;
            found = true;
            URL url = new URL(link + '/' + line.replace("+", "%2B"));
            String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
            logger.info("Downloading {} ...", (Object)url);
            try (GZIPInputStream fis = new GZIPInputStream(url.openStream());){
                Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return found;
    }
}

