/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.summary;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

public final class ImageSummary
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "ImageSummary";
    private Output<TString> summary;

    public static <T extends TNumber> ImageSummary create(Scope scope, Operand<TString> tag, Operand<T> tensor, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(tag.asOutput());
        opBuilder.addInput(tensor.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxImages != null) {
                    opBuilder.setAttr("max_images", opts.maxImages);
                }
                if (opts.badColor == null) continue;
                opBuilder.setAttr("bad_color", opts.badColor);
            }
        }
        return new ImageSummary(opBuilder.build());
    }

    public static Options maxImages(Long maxImages) {
        return new Options().maxImages(maxImages);
    }

    public static Options badColor(Tensor<?> badColor) {
        return new Options().badColor(badColor);
    }

    public Output<TString> summary() {
        return this.summary;
    }

    @Override
    public Output<TString> asOutput() {
        return this.summary;
    }

    private ImageSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxImages;
        private Tensor<?> badColor;

        public Options maxImages(Long maxImages) {
            this.maxImages = maxImages;
            return this;
        }

        public Options badColor(Tensor<?> badColor) {
            this.badColor = badColor;
            return this;
        }

        private Options() {
        }
    }
}

