/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class SparseSplit<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseSplit";
    private List<Output<TInt64>> outputIndices;
    private List<Output<T>> outputValues;
    private List<Output<TInt64>> outputShape;

    public static <T extends TType> SparseSplit<T> create(Scope scope, Operand<TInt64> splitDim, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> shape, Long numSplit) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(splitDim.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_split", numSplit);
        return new SparseSplit<T>(opBuilder.build());
    }

    public List<Output<TInt64>> outputIndices() {
        return this.outputIndices;
    }

    public List<Output<T>> outputValues() {
        return this.outputValues;
    }

    public List<Output<TInt64>> outputShape() {
        return this.outputShape;
    }

    private SparseSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputIndicesLength = operation.outputListLength("output_indices");
        this.outputIndices = Arrays.asList(operation.outputList(outputIdx, outputIndicesLength));
        int outputValuesLength = operation.outputListLength("output_values");
        this.outputValues = Arrays.asList(operation.outputList(outputIdx += outputIndicesLength, outputValuesLength));
        int outputShapeLength = operation.outputListLength("output_shape");
        this.outputShape = Arrays.asList(operation.outputList(outputIdx += outputValuesLength, outputShapeLength));
        outputIdx += outputShapeLength;
    }
}

