/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class Quantize<T extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizeV2";
    private Output<T> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public static <T extends TType> Quantize<T> create(Scope scope, Operand<TFloat32> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, DataType<T> T, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("Quantize"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minRange.asOutput());
        opBuilder.addInput(maxRange.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("T", T);
        if (options != null) {
            for (Options opts : options) {
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.roundMode != null) {
                    opBuilder.setAttr("round_mode", opts.roundMode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis != null) {
                    opBuilder.setAttr("axis", opts.axis);
                }
                if (opts.ensureMinimumRange == null) continue;
                opBuilder.setAttr("ensure_minimum_range", opts.ensureMinimumRange.floatValue());
            }
        }
        return new Quantize<T>(opBuilder.build());
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public static Options ensureMinimumRange(Float ensureMinimumRange) {
        return new Options().ensureMinimumRange(ensureMinimumRange);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    private Quantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static class Options {
        private String mode;
        private String roundMode;
        private Boolean narrowRange;
        private Long axis;
        private Float ensureMinimumRange;

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        public Options ensureMinimumRange(Float ensureMinimumRange) {
            this.ensureMinimumRange = ensureMinimumRange;
            return this;
        }

        private Options() {
        }
    }
}

