/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class FakeQuantWithMinMaxVarsPerChannel
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "FakeQuantWithMinMaxVarsPerChannel";
    private Output<TFloat32> outputs;

    public static FakeQuantWithMinMaxVarsPerChannel create(Scope scope, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsPerChannel(opBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<TFloat32> outputs() {
        return this.outputs;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputs;
    }

    private FakeQuantWithMinMaxVarsPerChannel(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

