/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class MaxPoolWithArgmax<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "MaxPoolWithArgmax";
    private Output<T> output;
    private Output<U> argmax;

    public static <T extends TNumber, U extends TNumber> MaxPoolWithArgmax<T, U> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, DataType<U> Targmax, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("Targmax", Targmax);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.includeBatchInIndex == null) continue;
                opBuilder.setAttr("include_batch_in_index", opts.includeBatchInIndex);
            }
        }
        return new MaxPoolWithArgmax<T, U>(opBuilder.build());
    }

    public static <T extends TNumber> MaxPoolWithArgmax<T, TInt64> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        return MaxPoolWithArgmax.create(scope, input, ksize, strides, TInt64.DTYPE, padding, options);
    }

    public static Options includeBatchInIndex(Boolean includeBatchInIndex) {
        return new Options().includeBatchInIndex(includeBatchInIndex);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<U> argmax() {
        return this.argmax;
    }

    private MaxPoolWithArgmax(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.argmax = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean includeBatchInIndex;

        public Options includeBatchInIndex(Boolean includeBatchInIndex) {
            this.includeBatchInIndex = includeBatchInIndex;
            return this;
        }

        private Options() {
        }
    }
}

