/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class FusedBatchNorm<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "FusedBatchNormV3";
    private Output<T> y;
    private Output<U> batchMean;
    private Output<U> batchVariance;
    private Output<U> reserveSpace1;
    private Output<U> reserveSpace2;
    private Output<U> reserveSpace3;

    public static <T extends TNumber, U extends TNumber> FusedBatchNorm<T, U> create(Scope scope, Operand<T> x, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("FusedBatchNorm"));
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(offset.asOutput());
        opBuilder.addInput(mean.asOutput());
        opBuilder.addInput(variance.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.exponentialAvgFactor != null) {
                    opBuilder.setAttr("exponential_avg_factor", opts.exponentialAvgFactor.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNorm<T, U>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options exponentialAvgFactor(Float exponentialAvgFactor) {
        return new Options().exponentialAvgFactor(exponentialAvgFactor);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> y() {
        return this.y;
    }

    public Output<U> batchMean() {
        return this.batchMean;
    }

    public Output<U> batchVariance() {
        return this.batchVariance;
    }

    public Output<U> reserveSpace1() {
        return this.reserveSpace1;
    }

    public Output<U> reserveSpace2() {
        return this.reserveSpace2;
    }

    public Output<U> reserveSpace3() {
        return this.reserveSpace3;
    }

    private FusedBatchNorm(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
        this.batchMean = operation.output(outputIdx++);
        this.batchVariance = operation.output(outputIdx++);
        this.reserveSpace1 = operation.output(outputIdx++);
        this.reserveSpace2 = operation.output(outputIdx++);
        this.reserveSpace3 = operation.output(outputIdx++);
    }

    public static class Options {
        private Float epsilon;
        private Float exponentialAvgFactor;
        private String dataFormat;
        private Boolean isTraining;

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options exponentialAvgFactor(Float exponentialAvgFactor) {
            this.exponentialAvgFactor = exponentialAvgFactor;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

