/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class CtcBeamSearchDecoder<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "CTCBeamSearchDecoder";
    private List<Output<TInt64>> decodedIndices;
    private List<Output<TInt64>> decodedValues;
    private List<Output<TInt64>> decodedShape;
    private Output<T> logProbability;

    public static <T extends TNumber> CtcBeamSearchDecoder<T> create(Scope scope, Operand<T> inputs, Operand<TInt32> sequenceLength, Long beamWidth, Long topPaths, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("CtcBeamSearchDecoder"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("beam_width", beamWidth);
        opBuilder.setAttr("top_paths", topPaths);
        if (options != null) {
            for (Options opts : options) {
                if (opts.mergeRepeated == null) continue;
                opBuilder.setAttr("merge_repeated", opts.mergeRepeated);
            }
        }
        return new CtcBeamSearchDecoder<T>(opBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public List<Output<TInt64>> decodedIndices() {
        return this.decodedIndices;
    }

    public List<Output<TInt64>> decodedValues() {
        return this.decodedValues;
    }

    public List<Output<TInt64>> decodedShape() {
        return this.decodedShape;
    }

    public Output<T> logProbability() {
        return this.logProbability;
    }

    private CtcBeamSearchDecoder(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int decodedIndicesLength = operation.outputListLength("decoded_indices");
        this.decodedIndices = Arrays.asList(operation.outputList(outputIdx, decodedIndicesLength));
        int decodedValuesLength = operation.outputListLength("decoded_values");
        this.decodedValues = Arrays.asList(operation.outputList(outputIdx += decodedIndicesLength, decodedValuesLength));
        int decodedShapeLength = operation.outputListLength("decoded_shape");
        this.decodedShape = Arrays.asList(operation.outputList(outputIdx += decodedValuesLength, decodedShapeLength));
        outputIdx += decodedShapeLength;
        this.logProbability = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean mergeRepeated;

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        private Options() {
        }
    }
}

