/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;

public final class CTCLossV2
extends RawOp {
    private Output<TFloat32> loss;
    private Output<TFloat32> gradient;

    public static CTCLossV2 create(Scope scope, Operand<TFloat32> inputs, Operand<TInt64> labelsIndices, Operand<TInt32> labelsValues, Operand<TInt32> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CTCLossV2", scope.makeOpName("CTCLossV2"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(labelsIndices.asOutput());
        opBuilder.addInput(labelsValues.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.preprocessCollapseRepeated != null) {
                    opBuilder.setAttr("preprocess_collapse_repeated", opts.preprocessCollapseRepeated);
                }
                if (opts.ctcMergeRepeated != null) {
                    opBuilder.setAttr("ctc_merge_repeated", opts.ctcMergeRepeated);
                }
                if (opts.ignoreLongerOutputsThanInputs == null) continue;
                opBuilder.setAttr("ignore_longer_outputs_than_inputs", opts.ignoreLongerOutputsThanInputs);
            }
        }
        return new CTCLossV2(opBuilder.build());
    }

    public static Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
        return new Options().preprocessCollapseRepeated(preprocessCollapseRepeated);
    }

    public static Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
        return new Options().ctcMergeRepeated(ctcMergeRepeated);
    }

    public static Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
        return new Options().ignoreLongerOutputsThanInputs(ignoreLongerOutputsThanInputs);
    }

    public Output<TFloat32> loss() {
        return this.loss;
    }

    public Output<TFloat32> gradient() {
        return this.gradient;
    }

    private CTCLossV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.loss = operation.output(outputIdx++);
        this.gradient = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean preprocessCollapseRepeated;
        private Boolean ctcMergeRepeated;
        private Boolean ignoreLongerOutputsThanInputs;

        public Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
            this.preprocessCollapseRepeated = preprocessCollapseRepeated;
            return this;
        }

        public Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
            this.ctcMergeRepeated = ctcMergeRepeated;
            return this;
        }

        public Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
            this.ignoreLongerOutputsThanInputs = ignoreLongerOutputsThanInputs;
            return this;
        }

        private Options() {
        }
    }
}

